/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.phantom.task.impl.TaskHandlerExecutorRepository;
import com.flipkart.phantom.task.impl.TaskRequestWrapper;
import com.flipkart.phantom.task.impl.TaskResult;
import com.flipkart.phantom.task.spi.Decoder;
import com.flipkart.phantom.task.spi.RequestContext;
import com.flipkart.phantom.task.spi.TaskContext;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ServerSpan;
import com.google.common.base.Optional;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskContextImpl
implements TaskContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskContextImpl.class);
    private static final String GET_CONFIG_COMMAND = "getConfig";
    private static String hostName;
    private ObjectMapper objectMapper = new ObjectMapper();
    private TaskHandlerExecutorRepository executorRepository;

    static {
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.error("Unable to find host name", (Throwable)e);
        }
    }

    @Override
    public String getConfig(String group, String key, int count) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("group", group);
        params.put("key", key);
        params.put("count", Integer.toString(count));
        TaskResult result = this.executeCommand(GET_CONFIG_COMMAND, null, params);
        if (result == null) {
            return "";
        }
        return new String((byte[])result.getData());
    }

    @Override
    public TaskResult executeCommand(String commandName, byte[] data, Map<String, String> params) throws UnsupportedOperationException {
        return this.executorRepository.executeCommand(commandName, this.createRequestFromParams(commandName, data, params));
    }

    @Override
    public <T> TaskResult<T> executeCommand(String commandName, TaskRequestWrapper taskRequestWrapper, Decoder<T> decoder) throws UnsupportedOperationException {
        return this.executorRepository.executeCommand(commandName, taskRequestWrapper, decoder);
    }

    @Override
    public <T> TaskResult<T> executeCommand(String commandName, byte[] data, Map<String, String> params, Decoder<T> decoder) throws UnsupportedOperationException {
        return this.executorRepository.executeCommand(commandName, this.createRequestFromParams(commandName, data, params), decoder);
    }

    @Override
    public Future<TaskResult> executeAsyncCommand(String commandName, byte[] data, Map<String, String> params, Decoder decoder) throws UnsupportedOperationException {
        return this.executorRepository.executeAsyncCommand(commandName, this.createRequestFromParams(commandName, data, params), decoder);
    }

    @Override
    public Future<TaskResult> executeAsyncCommand(String commandName, byte[] data, Map<String, String> params) throws UnsupportedOperationException {
        return this.executorRepository.executeAsyncCommand(commandName, this.createRequestFromParams(commandName, data, params));
    }

    private TaskRequestWrapper createRequestFromParams(String commandName, byte[] data, Map<String, String> params) {
        TaskRequestWrapper taskRequestWrapper = new TaskRequestWrapper();
        taskRequestWrapper.setCommandName(commandName);
        taskRequestWrapper.setData(data);
        taskRequestWrapper.setParams(params);
        ServerSpan serverSpan = Brave.getServerSpanThreadBinder().getCurrentServerSpan();
        if (serverSpan.getSpan() != null) {
            RequestContext serverRequestContext = new RequestContext();
            serverRequestContext.setCurrentServerSpan(serverSpan);
            taskRequestWrapper.setRequestContext((Optional<RequestContext>)Optional.of((Object)serverRequestContext));
        }
        return taskRequestWrapper;
    }

    public TaskHandlerExecutorRepository getExecutorRepository() {
        return this.executorRepository;
    }

    public void setExecutorRepository(TaskHandlerExecutorRepository executorRepository) {
        this.executorRepository = executorRepository;
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public String getHostName() {
        return hostName;
    }
}

