/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.impl;

import com.flipkart.phantom.event.ServiceProxyEvent;
import com.flipkart.phantom.event.ServiceProxyEventProducer;
import com.flipkart.phantom.task.impl.HystrixTaskHandler;
import com.flipkart.phantom.task.impl.RequestCacheableHystrixTaskHandler;
import com.flipkart.phantom.task.impl.RequestCacheableTaskHandlerExecutor;
import com.flipkart.phantom.task.impl.TaskHandler;
import com.flipkart.phantom.task.impl.TaskHandlerExecutor;
import com.flipkart.phantom.task.impl.interceptor.ClientRequestInterceptor;
import com.flipkart.phantom.task.impl.interceptor.CommandClientResponseInterceptor;
import com.flipkart.phantom.task.impl.registry.TaskHandlerRegistry;
import com.flipkart.phantom.task.impl.repository.AbstractExecutorRepository;
import com.flipkart.phantom.task.spi.Decoder;
import com.flipkart.phantom.task.spi.Executor;
import com.flipkart.phantom.task.spi.RequestWrapper;
import com.flipkart.phantom.task.spi.TaskRequestWrapper;
import com.flipkart.phantom.task.spi.TaskResult;
import com.netflix.hystrix.HystrixCommandProperties;
import java.util.Map;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskHandlerExecutorRepository
extends AbstractExecutorRepository<TaskRequestWrapper, TaskResult, TaskHandler> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskHandlerExecutorRepository.class);
    public static final String ONLY_ALPHANUMERIC_REGEX = "[^\\dA-Za-z_]";
    public static final String WHITESPACE_REGEX = "\\s+";
    private static final int DEFAULT_THREAD_POOL_SIZE = 10;
    private ServiceProxyEventProducer eventProducer;

    @Override
    public Executor<TaskRequestWrapper, TaskResult> getExecutor(String commandName, String proxyName, TaskRequestWrapper requestWrapper) {
        Executor<TaskRequestWrapper, TaskResult> executor = null;
        String refinedCommandName = this.getRefinedName(commandName);
        String refinedProxyName = this.getRefinedName(proxyName);
        TaskHandler taskHandler = this.getTaskHandler(commandName, refinedCommandName, proxyName, refinedProxyName, requestWrapper);
        int maxConcurrency = this.getMaxConcurrency(taskHandler, proxyName);
        int executionTimeout = this.getExecutionTimeout(taskHandler, commandName);
        executor = taskHandler instanceof HystrixTaskHandler ? (((HystrixTaskHandler)taskHandler).getIsolationStrategy() == HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE ? this.getTaskHandlerExecutorWithSemaphoreIsolation(requestWrapper, refinedCommandName, taskHandler, maxConcurrency) : this.getTaskHandlerExecutor(requestWrapper, refinedCommandName, refinedProxyName, maxConcurrency, executionTimeout, taskHandler)) : this.getTaskHandlerExecutor(requestWrapper, refinedCommandName, refinedProxyName, maxConcurrency, executionTimeout, taskHandler);
        return this.wrapExecutorWithInterceptors(executor, taskHandler);
    }

    public Executor<TaskRequestWrapper, TaskResult> getExecutor(String commandName, String proxyName, TaskRequestWrapper requestWrapper, Decoder decoder) {
        Executor<TaskRequestWrapper, TaskResult> executor = null;
        String refinedCommandName = this.getRefinedName(commandName);
        String refinedProxyName = this.getRefinedName(proxyName);
        TaskHandler taskHandler = this.getTaskHandler(commandName, refinedCommandName, proxyName, refinedProxyName, requestWrapper);
        int maxConcurrency = this.getMaxConcurrency(taskHandler, proxyName);
        int executionTimeout = this.getExecutionTimeout(taskHandler, commandName);
        executor = taskHandler instanceof HystrixTaskHandler ? (((HystrixTaskHandler)taskHandler).getIsolationStrategy() == HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE ? this.getTaskHandlerExecutorWithSemaphoreIsolationAndDecoder(requestWrapper, refinedCommandName, taskHandler, maxConcurrency, decoder) : this.getTaskHandlerExecutorWithDecoder(requestWrapper, refinedCommandName, refinedProxyName, maxConcurrency, executionTimeout, taskHandler, decoder)) : this.getTaskHandlerExecutorWithDecoder(requestWrapper, refinedCommandName, refinedProxyName, maxConcurrency, executionTimeout, taskHandler, decoder);
        return this.wrapExecutorWithInterceptors(executor, taskHandler);
    }

    public Executor<TaskRequestWrapper, TaskResult> getExecutor(String commandName, TaskRequestWrapper requestWrapper) {
        return this.getExecutor(commandName, commandName, requestWrapper);
    }

    public Future<TaskResult> executeAsyncCommand(String commandName, String proxyName, TaskRequestWrapper requestWrapper) throws UnsupportedOperationException {
        TaskHandlerExecutor command = (TaskHandlerExecutor)this.getExecutor(commandName, proxyName, requestWrapper);
        if (command == null) {
            throw new UnsupportedOperationException("Invoked unsupported command : " + commandName);
        }
        return command.queue();
    }

    public TaskResult executeCommand(String commandName, String proxyName, TaskRequestWrapper requestWrapper) throws UnsupportedOperationException {
        long receiveTime = System.currentTimeMillis();
        TaskHandlerExecutor command = (TaskHandlerExecutor)this.getExecutor(commandName, proxyName, requestWrapper);
        if (command == null) {
            throw new UnsupportedOperationException("Invoked unsupported command : " + commandName);
        }
        try {
            TaskResult taskResult = (TaskResult)command.execute();
            return taskResult;
        }
        catch (Exception e) {
            throw new RuntimeException("Error in processing command " + commandName + ": " + e.getMessage(), e);
        }
        finally {
            this.publishEvent(command, receiveTime, requestWrapper);
        }
    }

    public TaskResult executeCommand(String commandName, TaskRequestWrapper requestWrapper) throws UnsupportedOperationException {
        return this.executeCommand(commandName, commandName, requestWrapper);
    }

    public <T> TaskResult<T> executeCommand(String commandName, TaskRequestWrapper requestWrapper, Decoder<T> decoder) throws UnsupportedOperationException {
        long receiveTime = System.currentTimeMillis();
        TaskHandlerExecutor command = (TaskHandlerExecutor)this.getExecutor(commandName, commandName, requestWrapper, decoder);
        if (command == null) {
            throw new UnsupportedOperationException("Invoked unsupported command : " + commandName);
        }
        try {
            TaskResult taskResult = (TaskResult)command.execute();
            return taskResult;
        }
        catch (Exception e) {
            throw new RuntimeException("Error in processing command " + commandName + ": " + e.getMessage(), e);
        }
        finally {
            this.publishEvent(command, receiveTime, requestWrapper);
        }
    }

    public Future<TaskResult> executeAsyncCommand(String commandName, TaskRequestWrapper requestWrapper, Decoder decoder) throws UnsupportedOperationException {
        TaskHandlerExecutor command = (TaskHandlerExecutor)this.getExecutor(commandName, commandName, requestWrapper, decoder);
        if (command == null) {
            throw new UnsupportedOperationException("Invoked unsupported command : " + commandName);
        }
        return command.queue();
    }

    public Future<TaskResult> executeAsyncCommand(String commandName, TaskRequestWrapper requestWrapper) throws UnsupportedOperationException {
        return this.executeAsyncCommand(commandName, commandName, requestWrapper);
    }

    private Executor<TaskRequestWrapper, TaskResult> getTaskHandlerExecutorWithSemaphoreIsolation(TaskRequestWrapper requestWrapper, String refinedCommandName, TaskHandler taskHandler, int maxConcurrentSize) {
        if (taskHandler instanceof RequestCacheableHystrixTaskHandler) {
            return new RequestCacheableTaskHandlerExecutor((RequestCacheableHystrixTaskHandler)taskHandler, this.getTaskContext(), refinedCommandName, requestWrapper, maxConcurrentSize);
        }
        return new TaskHandlerExecutor(taskHandler, this.getTaskContext(), refinedCommandName, requestWrapper, maxConcurrentSize);
    }

    private Executor<TaskRequestWrapper, TaskResult> getTaskHandlerExecutor(TaskRequestWrapper requestWrapper, String refinedCommandName, String refinedProxyName, int maxConcurrentSize, int executorTimeOut, TaskHandler taskHandler) {
        if (taskHandler instanceof RequestCacheableHystrixTaskHandler) {
            return new RequestCacheableTaskHandlerExecutor((RequestCacheableHystrixTaskHandler)taskHandler, this.getTaskContext(), refinedCommandName, executorTimeOut, refinedProxyName, maxConcurrentSize, requestWrapper);
        }
        return new TaskHandlerExecutor(taskHandler, this.getTaskContext(), refinedCommandName, executorTimeOut, refinedProxyName, maxConcurrentSize, requestWrapper);
    }

    private Executor<TaskRequestWrapper, TaskResult> getTaskHandlerExecutorWithSemaphoreIsolationAndDecoder(TaskRequestWrapper requestWrapper, String refinedCommandName, TaskHandler taskHandler, int maxConcurrentSize, Decoder decoder) {
        if (taskHandler instanceof RequestCacheableHystrixTaskHandler) {
            return new RequestCacheableTaskHandlerExecutor((RequestCacheableHystrixTaskHandler)taskHandler, this.getTaskContext(), refinedCommandName, requestWrapper, maxConcurrentSize, decoder);
        }
        return new TaskHandlerExecutor(taskHandler, this.getTaskContext(), refinedCommandName, requestWrapper, maxConcurrentSize, decoder);
    }

    private Executor<TaskRequestWrapper, TaskResult> getTaskHandlerExecutorWithDecoder(TaskRequestWrapper requestWrapper, String refinedCommandName, String refinedProxyName, int maxConcurrentSize, int executorTimeOut, TaskHandler taskHandler, Decoder decoder) {
        if (taskHandler instanceof RequestCacheableHystrixTaskHandler) {
            return new RequestCacheableTaskHandlerExecutor((RequestCacheableHystrixTaskHandler)taskHandler, this.getTaskContext(), refinedCommandName, executorTimeOut, refinedProxyName, maxConcurrentSize, requestWrapper, decoder);
        }
        return new TaskHandlerExecutor(taskHandler, this.getTaskContext(), refinedCommandName, executorTimeOut, refinedProxyName, maxConcurrentSize, requestWrapper, decoder);
    }

    private Executor<TaskRequestWrapper, TaskResult> wrapExecutorWithInterceptors(Executor<TaskRequestWrapper, TaskResult> executor, TaskHandler taskHandler) {
        ClientRequestInterceptor tracingRequestInterceptor = new ClientRequestInterceptor();
        CommandClientResponseInterceptor tracingResponseInterceptor = new CommandClientResponseInterceptor();
        return this.wrapExecutorWithInterceptors(executor, taskHandler, tracingRequestInterceptor, tracingResponseInterceptor);
    }

    private int getExecutionTimeout(TaskHandler taskHandler, String commandName) {
        int executionTimeout = 1000;
        if (taskHandler instanceof HystrixTaskHandler) {
            executionTimeout = ((HystrixTaskHandler)taskHandler).getExecutorTimeout(commandName);
        }
        return executionTimeout;
    }

    private int getMaxConcurrency(TaskHandler taskHandler, String proxyName) {
        int maxConcurrentSize = 10;
        if (taskHandler instanceof HystrixTaskHandler) {
            HystrixTaskHandler hystrixTaskHandler = (HystrixTaskHandler)taskHandler;
            LOGGER.debug("Isolation strategy: " + hystrixTaskHandler.getIsolationStrategy() + " for " + hystrixTaskHandler);
            if (((TaskHandlerRegistry)this.getRegistry()).getPoolSize(proxyName) != null) {
                LOGGER.debug("Found a predefined pool size for " + proxyName + ". Not using default value of " + 10);
                maxConcurrentSize = ((TaskHandlerRegistry)this.getRegistry()).getPoolSize(proxyName);
            }
        }
        return maxConcurrentSize;
    }

    private String getRefinedName(String name) {
        return name.replaceAll(ONLY_ALPHANUMERIC_REGEX, "").replaceAll(WHITESPACE_REGEX, "");
    }

    private TaskHandler getTaskHandler(String commandName, String refinedCommandName, String proxyName, String refinedProxyName, RequestWrapper requestWrapper) {
        TaskHandler taskHandler;
        if (!commandName.equals(refinedCommandName)) {
            LOGGER.debug("Command names are not allowed to have Special characters/ whitespaces. Replacing: " + commandName + " with " + refinedCommandName);
        }
        if (!proxyName.equals(refinedProxyName)) {
            LOGGER.debug("Thread pool names are not allowed to have Special characters/ whitespaces. Replacing: " + proxyName + " with " + refinedProxyName);
        }
        if (proxyName.isEmpty()) {
            proxyName = commandName;
            LOGGER.debug("null/empty threadPoolName passed. defaulting to commandName: " + commandName);
        }
        if ((taskHandler = ((TaskHandlerRegistry)this.getRegistry()).getTaskHandlerByCommand(commandName)) != null) {
            if (!taskHandler.isActive()) {
                LOGGER.error("TaskHandler: " + taskHandler.getName() + " is not yet active. Command: " + commandName + " will not be processed");
                return null;
            }
        } else {
            throw new UnsupportedOperationException("Invoked unsupported command : " + commandName);
        }
        return taskHandler;
    }

    private void publishEvent(TaskHandlerExecutor command, long receiveTime, TaskRequestWrapper requestWrapper) {
        if (this.eventProducer != null) {
            Map<String, String> params = requestWrapper.getParams();
            ServiceProxyEvent.Builder eventBuilder = command.getEventBuilder().withCommandData(command).withEventSource(command.getClass().getName());
            eventBuilder.withRequestId(params.get("requestID")).withRequestReceiveTime(receiveTime);
            if (params.containsKey("requestSentTime")) {
                eventBuilder.withRequestSentTime(Long.valueOf(params.get("requestSentTime")));
            }
            this.eventProducer.publishEvent(eventBuilder.build());
        } else {
            LOGGER.debug("eventProducer not set, not publishing event");
        }
    }

    public void setEventProducer(ServiceProxyEventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }
}

