/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.impl.interceptor;

import com.flipkart.phantom.task.spi.RequestWrapper;
import com.flipkart.phantom.task.spi.interceptor.RequestInterceptor;
import com.flipkart.phantom.task.spi.interceptor.ResponseInterceptor;
import com.flipkart.phantom.task.spi.tracing.TraceData;
import com.github.kristofa.brave.BraveHttpHeaders;
import com.github.kristofa.brave.EndPointSubmitter;
import com.github.kristofa.brave.ServerTracer;
import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServerRequestInterceptor<T extends RequestWrapper, S>
implements RequestInterceptor<T>,
ResponseInterceptor<S> {
    private static final String FAILURE_ANNOTATION = "failure";
    private static final String REQUEST_ANNOTATION = "request";
    private String serviceHost;
    private int servicePort;
    private String serviceName;
    private ServerTracer serverTracer;
    private EndPointSubmitter endPointSubmitter;

    @Override
    public void process(T request) {
        this.endPointSubmitter.submit(this.serviceHost, this.servicePort, this.serviceName);
        TraceData traceData = this.getTraceDataFromHeaders(request);
        if (Boolean.FALSE.equals(traceData.shouldBeTraced())) {
            this.serverTracer.setStateNoTracing();
        } else {
            String spanName = this.getSpanName(traceData, request);
            if (traceData.getTraceId() != null && traceData.getSpanId() != null) {
                this.serverTracer.setStateCurrentTrace(traceData.getTraceId().longValue(), traceData.getSpanId().longValue(), traceData.getParentSpanId(), spanName);
            } else {
                this.serverTracer.setStateUnknown(spanName);
            }
        }
        Optional<String> requestMetadata = ((RequestWrapper)request).getRequestMetaData();
        if (requestMetadata.isPresent()) {
            this.serverTracer.submitBinaryAnnotation(REQUEST_ANNOTATION, (String)requestMetadata.get());
        }
        this.serverTracer.setServerReceived();
    }

    @Override
    public void process(S response, Optional<RuntimeException> transportError) {
        if (transportError.isPresent()) {
            this.serverTracer.submitAnnotation(FAILURE_ANNOTATION);
        }
        this.serverTracer.setServerSend();
    }

    private TraceData getTraceDataFromHeaders(T request) {
        TraceData traceData = new TraceData();
        if (((RequestWrapper)request).getHeaders().isPresent()) {
            HashMap headersMap = new HashMap();
            for (Map.Entry entry : (List)((RequestWrapper)request).getHeaders().get()) {
                headersMap.put(entry.getKey(), entry.getValue());
            }
            traceData.setTraceId(this.longOrNull((String)headersMap.get(BraveHttpHeaders.TraceId.getName())));
            traceData.setSpanId(this.longOrNull((String)headersMap.get(BraveHttpHeaders.SpanId.getName())));
            traceData.setParentSpanId(this.longOrNull((String)headersMap.get(BraveHttpHeaders.ParentSpanId.getName())));
            traceData.setShouldBeSampled(this.nullOrBoolean((String)headersMap.get(BraveHttpHeaders.Sampled.getName())));
            traceData.setSpanName((String)headersMap.get(BraveHttpHeaders.SpanName.getName()));
        }
        return traceData;
    }

    private Boolean nullOrBoolean(String value) {
        return value == null ? null : Boolean.valueOf(value);
    }

    private Long longOrNull(String value) {
        if (value == null) {
            return null;
        }
        return Long.parseLong(value, 16);
    }

    private String getSpanName(TraceData traceData, T request) {
        if (traceData.getSpanName() == null || traceData.getSpanName().isEmpty()) {
            return ((RequestWrapper)request).getRequestName();
        }
        return traceData.getSpanName();
    }

    public void setServerTracer(ServerTracer serverTracer) {
        this.serverTracer = serverTracer;
    }

    public void setEndPointSubmitter(EndPointSubmitter endPointSubmitter) {
        this.endPointSubmitter = endPointSubmitter;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setServiceHost(String serviceHost) {
        this.serviceHost = serviceHost;
    }

    public void setServicePort(int servicePort) {
        this.servicePort = servicePort;
    }
}

