/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.impl.repository;

import com.flipkart.phantom.task.impl.collector.EventDispatchingSpanCollector;
import com.flipkart.phantom.task.impl.interceptor.AbstractClientResponseInterceptor;
import com.flipkart.phantom.task.impl.interceptor.ClientRequestInterceptor;
import com.flipkart.phantom.task.spi.AbstractHandler;
import com.flipkart.phantom.task.spi.Executor;
import com.flipkart.phantom.task.spi.RequestContext;
import com.flipkart.phantom.task.spi.RequestWrapper;
import com.flipkart.phantom.task.spi.TaskContext;
import com.flipkart.phantom.task.spi.interceptor.RequestInterceptor;
import com.flipkart.phantom.task.spi.interceptor.ResponseInterceptor;
import com.flipkart.phantom.task.spi.registry.AbstractHandlerRegistry;
import com.flipkart.phantom.task.spi.repository.ExecutorRepository;
import com.github.kristofa.brave.TraceFilter;
import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public abstract class AbstractExecutorRepository<T extends RequestWrapper, S, R extends AbstractHandler>
implements ExecutorRepository<T, S, R>,
InitializingBean {
    protected AbstractHandlerRegistry<R> registry;
    protected TaskContext taskContext;
    protected List<RequestInterceptor<T>> requestInterceptors = new LinkedList<RequestInterceptor<T>>();
    protected List<ResponseInterceptor<S>> responseInterceptors = new LinkedList<ResponseInterceptor<S>>();
    protected EventDispatchingSpanCollector eventDispatchingSpanCollector;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.registry, (String)"The 'registry' may not be null");
        Assert.notNull((Object)this.taskContext, (String)"The 'taskContext' may not be null");
        Assert.notNull((Object)this.eventDispatchingSpanCollector, (String)"The 'eventDispatchingSpanCollector' may not be null");
    }

    /*
     * WARNING - void declaration
     */
    protected Executor<T, S> wrapExecutorWithInterceptors(Executor<T, S> executor, R handler, ClientRequestInterceptor<T> tracingRequestInterceptor, AbstractClientResponseInterceptor<S> tracingResponseInterceptor) {
        if (executor != null) {
            void var5_11;
            for (RequestInterceptor<T> requestInterceptor : this.requestInterceptors) {
                executor.addRequestInterceptor(requestInterceptor);
            }
            for (ResponseInterceptor responseInterceptor : this.responseInterceptors) {
                executor.addResponseInterceptor(responseInterceptor);
            }
            Optional<RequestContext> optional = ((RequestWrapper)executor.getRequestWrapper()).getRequestContext();
            List<TraceFilter> traceFilters = Arrays.asList(this.registry.getTraceFilterForHandler(((AbstractHandler)handler).getName()));
            if (!optional.isPresent()) {
                RequestContext newRequestContext = new RequestContext();
                Optional optional2 = Optional.of((Object)newRequestContext);
                ((RequestWrapper)executor.getRequestWrapper()).setRequestContext((Optional<RequestContext>)optional2);
            }
            if (((RequestContext)var5_11.get()).getCurrentServerSpan() == null) {
                String serviceName = executor.getServiceName().isPresent() ? (String)executor.getServiceName().get() : "Null Service";
                ((RequestContext)var5_11.get()).setCurrentClientEndpoint(new RequestContext.ServiceEndpoint(((AbstractHandler)handler).getHost(), ((AbstractHandler)handler).getPort(), serviceName));
                tracingRequestInterceptor.setEventDispatchingSpanCollector(this.eventDispatchingSpanCollector);
                tracingRequestInterceptor.setTraceFilters(traceFilters);
                executor.addRequestInterceptor(tracingRequestInterceptor);
                tracingResponseInterceptor.setEventDispatchingSpanCollector(this.eventDispatchingSpanCollector);
                tracingResponseInterceptor.setTraceFilters(traceFilters);
                executor.addResponseInterceptor(tracingResponseInterceptor);
            }
        }
        return executor;
    }

    @Override
    public AbstractHandlerRegistry<R> getRegistry() {
        return this.registry;
    }

    @Override
    public void setRegistry(AbstractHandlerRegistry<R> registry) {
        this.registry = registry;
    }

    @Override
    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    @Override
    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    public void setRequestInterceptors(List<RequestInterceptor<T>> requestInterceptors) {
        this.requestInterceptors = requestInterceptors;
    }

    public void setResponseInterceptors(List<ResponseInterceptor<S>> responseInterceptors) {
        this.responseInterceptors = responseInterceptors;
    }

    public void setEventDispatchingSpanCollector(EventDispatchingSpanCollector eventDispatchingSpanCollector) {
        this.eventDispatchingSpanCollector = eventDispatchingSpanCollector;
    }
}

