/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.spi;

import java.util.List;

public class TaskResult<T> {
    private static final int DEFAULT_LENGTH = 0;
    private final boolean success;
    private final String message;
    private final T data;
    private final List<T> dataList;
    private int length = 0;
    private boolean profilingDone = false;
    private byte[] metadata;

    public TaskResult(boolean success, String message) {
        this(success, message, null);
    }

    public TaskResult(boolean success, String message, T data) {
        this.success = success;
        this.message = message;
        this.data = data;
        this.dataList = null;
        if (data != null) {
            if (data instanceof byte[]) {
                byte[] dataBytes = (byte[])data;
                this.length = dataBytes.length;
            } else {
                this.length = 0;
            }
        }
    }

    public TaskResult(boolean success, String message, T data, byte[] metadata) {
        this.success = success;
        this.message = message;
        this.data = data;
        this.dataList = null;
        this.metadata = metadata;
        if (data != null) {
            if (data instanceof byte[]) {
                byte[] dataBytes = (byte[])data;
                this.length = metadata != null ? dataBytes.length + metadata.length : dataBytes.length;
            } else {
                this.length = 0;
            }
        }
    }

    public TaskResult(boolean success, String message, List<T> dataArray, int length) {
        this.success = success;
        this.message = message;
        this.data = null;
        this.dataList = dataArray;
        this.length = length;
    }

    public TaskResult(boolean success, String message, T data, boolean profilingDone) {
        this.success = success;
        this.message = message;
        this.data = data;
        this.dataList = null;
        if (data instanceof byte[]) {
            byte[] dataBytes = (byte[])data;
            this.length = dataBytes.length;
        } else {
            this.length = 0;
        }
        this.profilingDone = profilingDone;
    }

    public String toString() {
        return String.format("TaskResult[success:%s, message:%s,datalength:%d]", this.success, this.message, this.length);
    }

    public int getLength() {
        return this.length;
    }

    public boolean isDataArray() {
        return this.dataList != null;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getData() {
        return this.data;
    }

    public List<T> getDataArray() {
        return this.dataList;
    }

    public boolean isProfilingDone() {
        return this.profilingDone;
    }

    public byte[] getMetadata() {
        return this.metadata;
    }
}

