/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.spi.registry;

import java.io.File;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class HandlerConfigInfo {
    public static final int FIRST_ORDER = 0;
    public static final int DEFAULT_ORDER = 1;
    private int loadOrder = 1;
    public static final String BINARIES_PATH = "lib";
    public static final String FILE_PREFIX = "file:";
    private File xmlConfigFile;
    private String binariesPath = "lib";
    private AbstractApplicationContext proxyHandlerContext;
    private int version = 0;

    public HandlerConfigInfo(File xmlConfigFile) {
        this.xmlConfigFile = xmlConfigFile;
    }

    public HandlerConfigInfo(File xmlConfigFile, String binariesPath) {
        this(xmlConfigFile);
        this.binariesPath = binariesPath;
    }

    public HandlerConfigInfo(File xmlConfigFile, String binariesPath, AbstractApplicationContext proxyHandlerContext) {
        this(xmlConfigFile, binariesPath);
        this.proxyHandlerContext = proxyHandlerContext;
    }

    public AbstractApplicationContext loadProxyHandlerContext(ClassLoader classLoader, AbstractApplicationContext applicationContext) {
        ClassLoader existingTCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        this.proxyHandlerContext = new FileSystemXmlApplicationContext(new String[]{FILE_PREFIX + this.xmlConfigFile.getAbsolutePath()}, (ApplicationContext)applicationContext);
        Thread.currentThread().setContextClassLoader(existingTCCL);
        return this.proxyHandlerContext;
    }

    public boolean equals(Object object) {
        HandlerConfigInfo otherConfigInfo = (HandlerConfigInfo)object;
        return this.getXmlConfigFile().getAbsolutePath().equalsIgnoreCase(otherConfigInfo.getXmlConfigFile().getAbsolutePath());
    }

    public String toString() {
        return "HandlerConfigInfo [xmlConfigFile=" + this.xmlConfigFile + ", binariesPath=" + this.binariesPath + "]";
    }

    public AbstractApplicationContext getProxyHandlerContext() {
        return this.proxyHandlerContext;
    }

    public File getXmlConfigFile() {
        return this.xmlConfigFile;
    }

    public String getBinariesPath() {
        return this.binariesPath;
    }

    public int getLoadOrder() {
        return this.loadOrder;
    }

    public void setLoadOrder(int loadOrder) {
        this.loadOrder = loadOrder;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

