/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.event.consumer;

import com.flipkart.phantom.event.ServiceProxyEvent;
import com.netflix.hystrix.HystrixEventType;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.trpr.platform.core.impl.event.AbstractEndpointEventConsumerImpl;
import org.trpr.platform.core.impl.event.PlatformApplicationEvent;
import org.trpr.platform.core.spi.event.EndpointEventConsumer;
import org.trpr.platform.model.event.PlatformEvent;

public class RequestLogger
extends AbstractEndpointEventConsumerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestLogger.class);
    private static FastDateFormat dateFormatter = FastDateFormat.getInstance((String)"dd-MMM-yyyy_HH:mm:ss.SSS");
    private Map<String, EndpointEventConsumer> subscriptionConsumers = new HashMap<String, EndpointEventConsumer>();

    protected void handlePlatformEvent(PlatformEvent platformEvent) {
        if (platformEvent instanceof ServiceProxyEvent) {
            ServiceProxyEvent serviceProxyEvent = (ServiceProxyEvent)platformEvent;
            String subscriptionKey = "evt://com.flipkart.phantom.events." + serviceProxyEvent.getEventType();
            if (this.subscriptionConsumers.containsKey(subscriptionKey)) {
                this.subscriptionConsumers.get(subscriptionKey).onApplicationEvent((ApplicationEvent)new PlatformApplicationEvent(platformEvent));
            } else {
                this.log((ServiceProxyEvent)platformEvent);
            }
        } else {
            LOGGER.warn("Event Not Logged:Non compatible event received. Expecting ServiceProxyEvent Type but received " + platformEvent.getClass());
        }
    }

    public void addSubscriptionAndConsumer(String endpointURI, EndpointEventConsumer eventConsumer) {
        this.subscriptionConsumers.put(endpointURI, eventConsumer);
        LinkedList<String> allSubscriptions = new LinkedList<String>(Arrays.asList(this.getSubscriptions()));
        allSubscriptions.add(endpointURI);
        super.setSubscriptions(allSubscriptions.toArray(new String[0]));
    }

    private void log(ServiceProxyEvent event) {
        List<HystrixEventType> events = event.getHystrixEventList();
        if (events.size() > 0 && !events.contains(HystrixEventType.SUCCESS)) {
            LOGGER.error("ClientRequestId=" + event.getRequestId() + " " + "Command=" + event.getCommandName() + " " + (events.size() > 0 ? "Events=" + RequestLogger.eventsToString(events) + " " : "") + "SentTime=" + this.getFormattedTimeStamp(event.getRequestSentTime()) + " " + "ReceivedTime=" + this.getFormattedTimeStamp(event.getRequestReceiveTime()) + " " + "ExecutionStartTime=" + this.getFormattedTimeStamp(event.getRequestExecutionStartTime()) + " " + "ExecutionEndTime=" + dateFormatter.format(event.getCreatedDate().getTime()) + " " + "EventType=" + event.getEventType() + " " + "EventSource=" + event.getEventSource() + " " + "TimeTaken=" + event.getExecutionTime(), (Throwable)event.getException());
        }
    }

    private String getFormattedTimeStamp(long requestReceiveTime) {
        if (requestReceiveTime < 0L) {
            return String.valueOf(requestReceiveTime);
        }
        return dateFormatter.format(new Date(requestReceiveTime));
    }

    private static String eventsToString(List<HystrixEventType> events) {
        String joined = "";
        boolean first = true;
        for (HystrixEventType event : events) {
            if (first) {
                first = false;
            } else {
                joined = String.valueOf(joined) + ",";
            }
            joined = String.valueOf(joined) + event.name();
        }
        return joined;
    }
}

