/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.impl.registry;

import com.flipkart.phantom.task.impl.HystrixTaskHandler;
import com.flipkart.phantom.task.impl.TaskHandler;
import com.flipkart.phantom.task.spi.registry.AbstractHandlerRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class TaskHandlerRegistry
extends AbstractHandlerRegistry<TaskHandler> {
    private static final Logger LOGGER = LogFactory.getLogger(TaskHandlerRegistry.class);
    private Map<String, TaskHandler> commandToTaskHandler = new ConcurrentHashMap<String, TaskHandler>();
    private Map<String, Integer> concurrencyPoolSize = new ConcurrentHashMap<String, Integer>();

    public TaskHandler getTaskHandlerByCommand(String commandString) {
        return this.commandToTaskHandler.get(commandString);
    }

    public Integer getPoolSize(String poolOrCommandName) {
        return this.concurrencyPoolSize.get(poolOrCommandName);
    }

    @Override
    protected Class<TaskHandler> getHandlerType() {
        return TaskHandler.class;
    }

    @Override
    protected void postInitHandler(TaskHandler taskHandler) {
        String[] stringArray = taskHandler.getCommands();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String commandName = stringArray[n2];
            LOGGER.info("Registering task handler " + taskHandler.getName() + " with command " + commandName);
            if (!this.commandToTaskHandler.containsValue(taskHandler)) {
                this.initializeConcurrencyPoolMap(taskHandler);
            }
            if (this.commandToTaskHandler.get(commandName) != null) {
                throw new IllegalArgumentException("Command " + commandName + " is already registered with handler " + this.commandToTaskHandler.get(commandName).getName());
            }
            this.commandToTaskHandler.put(commandName, taskHandler);
            ++n2;
        }
    }

    @Override
    protected void postUnregisterHandler(TaskHandler handler) {
        String[] stringArray = handler.getCommands();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String commandName = stringArray[n2];
            this.commandToTaskHandler.remove(commandName);
            ++n2;
        }
    }

    private void initializeConcurrencyPoolMap(TaskHandler taskHandler) {
        if (taskHandler instanceof HystrixTaskHandler) {
            HystrixTaskHandler hystrixTaskHandler = (HystrixTaskHandler)taskHandler;
            Map<String, Integer> threadParams = hystrixTaskHandler.getConcurrentPoolSizeParams();
            for (String threadParam : threadParams.keySet()) {
                this.concurrencyPoolSize.put(threadParam, threadParams.get(threadParam));
            }
            Map<String, Integer> commandParams = hystrixTaskHandler.getCommandPoolSizeParams();
            for (String commandParam : commandParams.keySet()) {
                this.concurrencyPoolSize.put(commandParam, commandParams.get(commandParam));
            }
        }
    }
}

