/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.impl;

import com.flipkart.phantom.event.ServiceProxyEvent;
import com.flipkart.phantom.task.impl.HystrixTaskHandler;
import com.flipkart.phantom.task.impl.TaskHandler;
import com.flipkart.phantom.task.spi.Decoder;
import com.flipkart.phantom.task.spi.Executor;
import com.flipkart.phantom.task.spi.RequestContext;
import com.flipkart.phantom.task.spi.TaskContext;
import com.flipkart.phantom.task.spi.TaskRequestWrapper;
import com.flipkart.phantom.task.spi.TaskResult;
import com.flipkart.phantom.task.spi.interceptor.RequestInterceptor;
import com.flipkart.phantom.task.spi.interceptor.ResponseInterceptor;
import com.github.kristofa.brave.Brave;
import com.google.common.base.Optional;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TaskHandlerExecutor<S>
extends HystrixCommand<TaskResult>
implements Executor<TaskRequestWrapper<S>, TaskResult> {
    public static final String NO_RESULT = "The command returned no result";
    public static final String ASYNC_QUEUED = "The command dispatched for async execution";
    public static final String DEFAULT_HYSTRIX_GROUP = "DEFAULT_GROUP";
    public static final String DEFAULT_HYSTRIX_THREAD_POOL = "DEFAULT_THREAD_POOL";
    public static final int DEFAULT_HYSTRIX_THREAD_POOL_SIZE = 10;
    private static final String COMMAND_HANDLER = "COMMAND_HANDLER";
    protected TaskHandler taskHandler;
    protected TaskContext taskContext;
    protected String command;
    protected Map<String, String> params;
    protected S data;
    protected TaskRequestWrapper<S> taskRequestWrapper;
    protected Decoder decoder;
    protected ServiceProxyEvent.Builder eventBuilder;
    private List<RequestInterceptor<TaskRequestWrapper<S>>> requestInterceptors = new LinkedList<RequestInterceptor<TaskRequestWrapper<S>>>();
    private List<ResponseInterceptor<TaskResult>> responseInterceptors = new LinkedList<ResponseInterceptor<TaskResult>>();

    protected TaskHandlerExecutor(TaskHandler taskHandler, TaskContext taskContext, String commandName, int timeout, String threadPoolName, int threadPoolSize, TaskRequestWrapper<S> taskRequestWrapper) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)taskHandler.getName())).andCommandKey(HystrixCommandKey.Factory.asKey((String)commandName)).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)taskHandler.getVersionedThreadPoolName(threadPoolName))).andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withCoreSize(threadPoolSize)).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationThreadTimeoutInMilliseconds(timeout)));
        this.taskHandler = taskHandler;
        this.taskContext = taskContext;
        this.command = commandName;
        this.data = taskRequestWrapper.getData();
        this.params = taskRequestWrapper.getParams();
        this.taskRequestWrapper = taskRequestWrapper;
        this.eventBuilder = new ServiceProxyEvent.Builder(commandName, COMMAND_HANDLER);
    }

    protected TaskHandlerExecutor(TaskHandler taskHandler, TaskContext taskContext, String commandName, int timeout, String threadPoolName, int threadPoolSize, TaskRequestWrapper<S> taskRequestWrapper, Decoder decoder) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)taskHandler.getName())).andCommandKey(HystrixCommandKey.Factory.asKey((String)commandName)).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)taskHandler.getVersionedThreadPoolName(threadPoolName))).andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withCoreSize(threadPoolSize)).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationThreadTimeoutInMilliseconds(timeout)));
        this.taskHandler = taskHandler;
        this.taskContext = taskContext;
        this.command = commandName;
        this.data = taskRequestWrapper.getData();
        this.params = taskRequestWrapper.getParams();
        this.taskRequestWrapper = taskRequestWrapper;
        this.eventBuilder = new ServiceProxyEvent.Builder(commandName, COMMAND_HANDLER);
        this.decoder = decoder;
    }

    protected TaskHandlerExecutor(TaskHandler taskHandler, TaskContext taskContext, String commandName, TaskRequestWrapper<S> taskRequestWrapper, int concurrentRequestSize) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)taskHandler.getName())).andCommandKey(HystrixCommandKey.Factory.asKey((String)commandName)).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE).withExecutionIsolationSemaphoreMaxConcurrentRequests(concurrentRequestSize)));
        this.taskHandler = taskHandler;
        this.taskContext = taskContext;
        this.command = commandName;
        this.data = taskRequestWrapper.getData();
        this.params = taskRequestWrapper.getParams();
        this.taskRequestWrapper = taskRequestWrapper;
        this.eventBuilder = new ServiceProxyEvent.Builder(commandName, COMMAND_HANDLER);
    }

    protected TaskHandlerExecutor(TaskHandler taskHandler, TaskContext taskContext, String commandName, TaskRequestWrapper<S> taskRequestWrapper, int concurrentRequestSize, Decoder decoder) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)taskHandler.getName())).andCommandKey(HystrixCommandKey.Factory.asKey((String)commandName)).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE).withExecutionIsolationSemaphoreMaxConcurrentRequests(concurrentRequestSize)));
        this.taskHandler = taskHandler;
        this.taskContext = taskContext;
        this.command = commandName;
        this.data = taskRequestWrapper.getData();
        this.params = taskRequestWrapper.getParams();
        this.taskRequestWrapper = taskRequestWrapper;
        this.decoder = decoder;
        this.eventBuilder = new ServiceProxyEvent.Builder(commandName, COMMAND_HANDLER);
    }

    public TaskHandlerExecutor(TaskHandler taskHandler, TaskContext taskContext, String commandName, int executorTimeout, TaskRequestWrapper<S> taskRequestWrapper) {
        this(taskHandler, taskContext, commandName, executorTimeout, DEFAULT_HYSTRIX_THREAD_POOL, 10, taskRequestWrapper);
    }

    public TaskHandlerExecutor(TaskHandler taskHandler, TaskContext taskContext, String commandName, int executorTimeout, TaskRequestWrapper<S> taskRequestWrapper, Decoder decoder) {
        this(taskHandler, taskContext, commandName, executorTimeout, DEFAULT_HYSTRIX_THREAD_POOL, 10, taskRequestWrapper, decoder);
    }

    protected TaskResult run() throws Exception {
        this.eventBuilder.withRequestExecutionStartTime(System.currentTimeMillis());
        if (this.taskRequestWrapper.getRequestContext().isPresent() && ((RequestContext)this.taskRequestWrapper.getRequestContext().get()).getCurrentServerSpan() != null) {
            Brave.getServerSpanThreadBinder().setCurrentSpan(((RequestContext)this.taskRequestWrapper.getRequestContext().get()).getCurrentServerSpan());
        }
        for (RequestInterceptor<TaskRequestWrapper<S>> requestInterceptor : this.requestInterceptors) {
            requestInterceptor.process(this.taskRequestWrapper);
        }
        Optional transportException = Optional.absent();
        TaskResult result = null;
        try {
            result = this.decoder == null ? this.taskHandler.execute(this.taskContext, this.command, this.params, this.data) : this.taskHandler.execute(this.taskContext, this.command, this.taskRequestWrapper, this.decoder);
            if (result == null) {
                result = new TaskResult(true, NO_RESULT);
            }
        }
        catch (RuntimeException e) {
            transportException = Optional.of((Object)e);
            throw e;
        }
        finally {
            if (this.isResponseTimedOut() && result != null && HystrixTaskHandler.class.isAssignableFrom(this.taskHandler.getClass())) {
                ((HystrixTaskHandler)this.taskHandler).releaseResources(result);
            }
            for (ResponseInterceptor<TaskResult> responseInterceptor : this.responseInterceptors) {
                responseInterceptor.process(result, (Optional<RuntimeException>)transportException);
            }
        }
        if (!result.isSuccess()) {
            throw new RuntimeException("Command returned FALSE: " + result.getMessage());
        }
        return result;
    }

    protected TaskResult getFallback() {
        if (this.taskHandler instanceof HystrixTaskHandler) {
            HystrixTaskHandler hystrixTaskHandler = (HystrixTaskHandler)this.taskHandler;
            if (this.decoder == null) {
                return hystrixTaskHandler.getFallBack(this.taskContext, this.command, this.params, this.data);
            }
            return hystrixTaskHandler.getFallBack(this.taskContext, this.command, this.taskRequestWrapper, this.decoder);
        }
        return null;
    }

    @Override
    public void addRequestInterceptor(RequestInterceptor<TaskRequestWrapper<S>> requestInterceptor) {
        this.requestInterceptors.add(requestInterceptor);
    }

    @Override
    public void addResponseInterceptor(ResponseInterceptor<TaskResult> responseInterceptor) {
        this.responseInterceptors.add(responseInterceptor);
    }

    @Override
    public Optional<String> getServiceName() {
        return Optional.of((Object)this.taskHandler.getName());
    }

    @Override
    public TaskRequestWrapper<S> getRequestWrapper() {
        return this.taskRequestWrapper;
    }

    public int getCallInvocationType() {
        Integer callInvocationType;
        if (this.taskHandler.getCallInvocationTypePerCommand() != null && (callInvocationType = this.taskHandler.getCallInvocationTypePerCommand().get(this.command)) != null) {
            return callInvocationType;
        }
        return this.taskHandler.getCallInvocationType();
    }

    @Override
    public ServiceProxyEvent.Builder getEventBuilder() {
        return this.eventBuilder;
    }
}

