/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.impl.interceptor;

import com.flipkart.phantom.task.impl.collector.EventDispatchingSpanCollector;
import com.flipkart.phantom.task.spi.RequestContext;
import com.flipkart.phantom.task.spi.RequestWrapper;
import com.flipkart.phantom.task.spi.interceptor.RequestInterceptor;
import com.flipkart.phantom.task.spi.interceptor.SpanNameFilter;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.BraveHttpHeaders;
import com.github.kristofa.brave.ClientTracer;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.SpanId;
import com.github.kristofa.brave.TraceFilter;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClientRequestInterceptor<T extends RequestWrapper>
implements RequestInterceptor<T> {
    private static final String HOST_ANNOTATION = "host";
    private static final String REQUEST_ANNOTATION = "request";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private Optional<SpanNameFilter> spanNameFilter = Optional.absent();
    private EventDispatchingSpanCollector eventDispatchingSpanCollector;
    private List<TraceFilter> traceFilters;

    @Override
    public void process(T request) {
        Optional<String> requestMetadata;
        for (TraceFilter traceFilter : this.traceFilters) {
            if (traceFilter.trace(((RequestWrapper)request).getRequestName())) continue;
            return;
        }
        ClientTracer clientTracer = Brave.getClientTracer((SpanCollector)this.eventDispatchingSpanCollector, this.traceFilters);
        String spanName = this.getSpanName(request);
        SpanId newSpanId = clientTracer.startNewSpan(spanName);
        this.addTracingHeaders(request, newSpanId, spanName);
        if (((RequestWrapper)request).getRequestContext().isPresent() && ((RequestContext)((RequestWrapper)request).getRequestContext().get()).getCurrentClientEndpoint() != null) {
            clientTracer.setCurrentClientServiceName(((RequestContext)((RequestWrapper)request).getRequestContext().get()).getCurrentClientEndpoint().getServiceName());
            clientTracer.submitBinaryAnnotation(HOST_ANNOTATION, ((RequestContext)((RequestWrapper)request).getRequestContext().get()).getCurrentClientEndpoint().getHost() + ":" + ((RequestContext)((RequestWrapper)request).getRequestContext().get()).getCurrentClientEndpoint().getPort());
        }
        if ((requestMetadata = ((RequestWrapper)request).getRequestMetaData()).isPresent()) {
            clientTracer.submitBinaryAnnotation(REQUEST_ANNOTATION, (String)requestMetadata.get());
        }
        clientTracer.setClientSent();
    }

    protected String getSpanName(T request) {
        Optional<String> spanNameFromRequest = this.getSpanNameFromRequest(request);
        if (spanNameFromRequest.isPresent()) {
            return (String)spanNameFromRequest.get();
        }
        String spanName = ((RequestWrapper)request).getRequestName();
        if (this.spanNameFilter.isPresent()) {
            spanName = ((SpanNameFilter)this.spanNameFilter.get()).filterSpanName(spanName);
        }
        return spanName;
    }

    protected Optional<String> getSpanNameFromRequest(T request) {
        Optional spanName = Optional.absent();
        return spanName;
    }

    protected void addTracingHeaders(T request, SpanId spanId, String spanName) {
        HashMap headers = new HashMap();
        if (((RequestWrapper)request).getHeaders().isPresent()) {
            List existingHeaders = (List)((RequestWrapper)request).getHeaders().get();
            for (Map.Entry e : existingHeaders) {
                headers.put(e.getKey(), e.getValue());
            }
        }
        if (spanId != null) {
            headers.put(BraveHttpHeaders.Sampled.getName(), TRUE);
            headers.put(BraveHttpHeaders.TraceId.getName(), Long.toString(spanId.getTraceId(), 16));
            headers.put(BraveHttpHeaders.SpanId.getName(), Long.toString(spanId.getSpanId(), 16));
            if (spanId.getParentSpanId() != null) {
                headers.put(BraveHttpHeaders.ParentSpanId.getName(), Long.toString(spanId.getParentSpanId(), 16));
            }
            if (spanName != null) {
                headers.put(BraveHttpHeaders.SpanName.getName(), spanName);
            }
        } else {
            headers.put(BraveHttpHeaders.Sampled.getName(), FALSE);
        }
        ((RequestWrapper)request).setHeaders(Lists.newArrayList(headers.entrySet()));
    }

    public Optional<SpanNameFilter> getSpanNameFilter() {
        return this.spanNameFilter;
    }

    public void setSpanNameFilter(Optional<SpanNameFilter> spanNameFilter) {
        this.spanNameFilter = spanNameFilter;
    }

    public void setEventDispatchingSpanCollector(EventDispatchingSpanCollector eventDispatchingSpanCollector) {
        this.eventDispatchingSpanCollector = eventDispatchingSpanCollector;
    }

    public void setTraceFilters(List<TraceFilter> traceFilters) {
        this.traceFilters = traceFilters;
    }
}

