/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.impl.collector;

import com.flipkart.phantom.event.ServiceProxyEvent;
import com.flipkart.phantom.event.ServiceProxyEventProducer;
import com.github.kristofa.brave.SpanCollector;
import com.twitter.zipkin.gen.AnnotationType;
import com.twitter.zipkin.gen.BinaryAnnotation;
import com.twitter.zipkin.gen.Span;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;

public class EventDispatchingSpanCollector
implements SpanCollector {
    private static final String UTF_8 = "UTF-8";
    private static final String TRACING_COLLECTOR = "TRACING_COLLECTOR";
    private final Set<BinaryAnnotation> defaultAnnotations = new HashSet<BinaryAnnotation>();
    private ServiceProxyEventProducer eventProducer;

    public void collect(Span span) {
        if (!this.defaultAnnotations.isEmpty()) {
            for (BinaryAnnotation ba : this.defaultAnnotations) {
                span.addToBinary_annotations(ba);
            }
        }
        ServiceProxyEvent.Builder eventBuilder = new ServiceProxyEvent.Builder(span.getName(), TRACING_COLLECTOR);
        eventBuilder.withSpan(span);
        this.eventProducer.publishEvent(eventBuilder.build());
    }

    public void addDefaultAnnotation(String key, String value) {
        try {
            ByteBuffer bb = ByteBuffer.wrap(value.getBytes(UTF_8));
            BinaryAnnotation binaryAnnotation = new BinaryAnnotation();
            binaryAnnotation.setKey(key);
            binaryAnnotation.setValue(bb);
            binaryAnnotation.setAnnotation_type(AnnotationType.STRING);
            this.defaultAnnotations.add(binaryAnnotation);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public void close() {
    }

    public void setEventProducer(ServiceProxyEventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }
}

