/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.impl.collector;

import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.zipkin.ZipkinSpanCollector;
import com.github.kristofa.brave.zipkin.ZipkinSpanCollectorParams;
import com.twitter.zipkin.gen.Span;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DelegatingZipkinSpanCollector
implements SpanCollector,
InitializingBean {
    private ZipkinSpanCollectorParams zipkinSpanCollectorParams = new ZipkinSpanCollectorParams();
    private ZipkinSpanCollector zipkinSpanCollector;
    private String zipkinCollectorHost;
    private int zipkinCollectorPort;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.zipkinCollectorHost, (String)"The 'zipkinCollectorHost' may not be null");
        Assert.notNull((Object)this.zipkinCollectorPort, (String)"The 'zipkinCollectorPort' may not be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(Span span) {
        if (this.zipkinSpanCollector == null) {
            DelegatingZipkinSpanCollector delegatingZipkinSpanCollector = this;
            synchronized (delegatingZipkinSpanCollector) {
                if (this.zipkinSpanCollector == null) {
                    this.zipkinSpanCollector = new ZipkinSpanCollector(this.zipkinCollectorHost, this.zipkinCollectorPort, this.zipkinSpanCollectorParams);
                }
            }
        }
        this.zipkinSpanCollector.collect(span);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefaultAnnotation(String key, String value) {
        if (this.zipkinSpanCollector == null) {
            DelegatingZipkinSpanCollector delegatingZipkinSpanCollector = this;
            synchronized (delegatingZipkinSpanCollector) {
                if (this.zipkinSpanCollector == null) {
                    this.zipkinSpanCollector = new ZipkinSpanCollector(this.zipkinCollectorHost, this.zipkinCollectorPort, this.zipkinSpanCollectorParams);
                }
            }
        }
        this.zipkinSpanCollector.addDefaultAnnotation(key, value);
    }

    public void close() {
        this.zipkinSpanCollector.close();
    }

    public void setZipkinCollectorHost(String zipkinCollectorHost) {
        this.zipkinCollectorHost = zipkinCollectorHost;
    }

    public void setZipkinCollectorPort(int zipkinCollectorPort) {
        this.zipkinCollectorPort = zipkinCollectorPort;
    }

    public void setQueueSize(int queueSize) {
        this.zipkinSpanCollectorParams.setQueueSize(queueSize);
    }

    public void setBatchSize(int batchSize) {
        this.zipkinSpanCollectorParams.setBatchSize(batchSize);
    }

    public void setNrOfThreads(int nrOfThreads) {
        this.zipkinSpanCollectorParams.setNrOfThreads(nrOfThreads);
    }

    public void setSocketTimeout(int socketTimeout) {
        this.zipkinSpanCollectorParams.setSocketTimeout(socketTimeout);
    }

    public void setFailOnSetup(boolean failOnSetup) {
        this.zipkinSpanCollectorParams.setFailOnSetup(failOnSetup);
    }
}

