/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.polyguice.akka;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Cancellable;
import akka.actor.ExtensionId;
import akka.actor.Props;
import akka.actor.Scheduler;
import com.flipkart.polyguice.akka.Polka;
import com.flipkart.polyguice.akka.PolyguiceProvider;
import com.flipkart.polyguice.core.Component;
import com.flipkart.polyguice.core.ComponentContext;
import com.flipkart.polyguice.core.ComponentContextAware;
import com.flipkart.polyguice.core.External;
import com.flipkart.polyguice.core.Initializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

@Component
@Singleton
public class PolkaImpl
implements ComponentContextAware,
Initializable,
Polka {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolkaImpl.class);
    private ComponentContext compCtxt;
    @External(name="key.actorsystem", required=true)
    private ActorSystem actorSystem;
    private Map<String, ActorRef> actorMap = new HashMap<String, ActorRef>();

    public void setComponentContext(ComponentContext ctxt) {
        this.compCtxt = ctxt;
    }

    public void initialize() {
        this.actorSystem.registerExtension((ExtensionId)new PolyguiceProvider(this.compCtxt));
    }

    @Override
    public ActorRef getActor(String name) {
        if (this.actorMap.containsKey(name)) {
            return this.actorMap.get(name);
        }
        return null;
    }

    @Override
    public ActorRef getActor(String name, Props props) {
        if (this.actorMap.containsKey(name)) {
            return this.actorMap.get(name);
        }
        LOGGER.info("Creating new actor|Name={}|Props={}", (Object)name, (Object)props);
        ActorRef actor = this.actorSystem.actorOf(props, name);
        this.actorMap.put(name, actor);
        return actor;
    }

    @Override
    public void removeActor(String name) {
        if (!this.actorMap.containsKey(name)) {
            return;
        }
        LOGGER.info("Removing actor|Name={}", (Object)name);
        ActorRef ref = this.actorMap.get(name);
        this.actorSystem.stop(ref);
        this.actorMap.remove(name);
    }

    @Override
    public Cancellable schedule(long initialDelay, long interval, String actorName, Object message) {
        ActorRef actor = this.getActor(actorName);
        if (actor == null) {
            return null;
        }
        FiniteDuration initial = new FiniteDuration(initialDelay, TimeUnit.MILLISECONDS);
        FiniteDuration gap = new FiniteDuration(interval, TimeUnit.MILLISECONDS);
        Scheduler scheduler = this.actorSystem.scheduler();
        return scheduler.schedule(initial, gap, actor, message, (ExecutionContext)this.actorSystem.dispatcher(), ActorRef.noSender());
    }

    @Override
    public Cancellable runOnce(long initialDelay, String actorName, Object message) {
        ActorRef actor = this.getActor(actorName);
        if (actor == null) {
            return null;
        }
        FiniteDuration initial = new FiniteDuration(initialDelay, TimeUnit.MILLISECONDS);
        Scheduler scheduler = this.actorSystem.scheduler();
        return scheduler.scheduleOnce(initial, actor, message, (ExecutionContext)this.actorSystem.dispatcher(), ActorRef.noSender());
    }
}

