/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.polyguice.config;

import org.apache.commons.lang3.StringUtils;

public class TimeInterval {
    private long interval = -1L;

    public TimeInterval() {
    }

    public TimeInterval(String timeValue) {
        this.parseInterval(timeValue);
    }

    public void setValue(String timeValue) {
        this.parseInterval(timeValue);
    }

    public long getValue() {
        return this.interval;
    }

    private void parseInterval(String timeValue) {
        if (StringUtils.isBlank((CharSequence)timeValue)) {
            return;
        }
        timeValue = timeValue.toLowerCase();
        long factor = 1L;
        if (timeValue.endsWith("s")) {
            factor = 1000L;
        }
        if (timeValue.endsWith("m")) {
            factor = 60000L;
        }
        if (timeValue.endsWith("h")) {
            factor = 3600000L;
        }
        if (timeValue.endsWith("d")) {
            factor = 86400000L;
        }
        if (timeValue.endsWith("s") || timeValue.endsWith("m") || timeValue.endsWith("h") || timeValue.endsWith("d")) {
            timeValue = timeValue.substring(0, timeValue.length() - 1);
        }
        try {
            double value = Double.parseDouble(timeValue);
            this.interval = (long)(value * (double)factor);
        }
        catch (NumberFormatException exep) {
            this.interval = -1L;
        }
    }
}

