/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.polyguice.core.support;

import com.flipkart.polyguice.core.Bindable;
import com.flipkart.polyguice.core.Component;
import com.flipkart.polyguice.core.ComponentProcessor;
import com.flipkart.polyguice.core.NonBindable;
import com.flipkart.polyguice.core.support.SingletonKey;
import com.google.inject.Binder;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AutobindManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutobindManager.class);
    private Binder binder;
    private List<String> procNames;
    private List<SingletonKey> singletonKeys;

    AutobindManager(Binder binder) {
        this.binder = binder;
    }

    public void autobind(String[] scanPkgNames) {
        LOGGER.debug("start_autobind");
        for (String pkgName : scanPkgNames) {
            LOGGER.debug("scan_package {}", (Object)pkgName);
        }
        Reflections reflections = new Reflections((Object[])scanPkgNames);
        this.procNames = new ArrayList<String>();
        Set procClsList = reflections.getSubTypesOf(ComponentProcessor.class);
        LOGGER.debug("component processors: {}", (Object)procClsList.size());
        for (Class cls : procClsList) {
            String procId = this.bindComponentProcessor(cls);
            this.procNames.add(procId);
        }
        this.singletonKeys = new ArrayList<SingletonKey>();
        Set clsList = reflections.getTypesAnnotatedWith(Component.class);
        LOGGER.debug("components: {}", (Object)clsList.size());
        for (Class cls : clsList) {
            SingletonKey sk = this.bindComponent(cls);
            if (sk == null) continue;
            this.singletonKeys.add(sk);
        }
        LOGGER.debug("end_autobind");
    }

    public List<String> getComponentProcessors() {
        return this.procNames;
    }

    public List<SingletonKey> getSingletons() {
        return this.singletonKeys;
    }

    private String bindComponentProcessor(Class<?> cmpCls) {
        String objId = cmpCls.getName() + "#" + Long.toString(System.currentTimeMillis(), 36);
        Named named = Names.named((String)objId);
        this.createBindings(cmpCls, null, named);
        LOGGER.debug("bound component processor: {} to {}", (Object)cmpCls.getName(), (Object)objId);
        return objId;
    }

    private SingletonKey bindComponent(Class cmpCls) {
        Component ann = cmpCls.getAnnotation(Component.class);
        LOGGER.debug("binding component: type={}, name={}, namedOnly={}, value={}", new Object[]{cmpCls.getName(), ann.name(), ann.namedOnly(), ann.value()});
        Named named = null;
        if (ann.value() != null && ann.value().trim().length() > 0) {
            named = Names.named((String)ann.value());
        } else if (ann.name() != null && ann.name().trim().length() > 0) {
            named = Names.named((String)ann.name());
        }
        HashSet ifaces = new HashSet();
        this.retrieveInterfaces(cmpCls, ifaces);
        Set<Class<?>> bindables = this.retrieveBindables(ifaces);
        if (ann.namedOnly()) {
            return this.createBindings(cmpCls, null, named);
        }
        if (bindables.isEmpty()) {
            return this.createBindings(cmpCls, ifaces, named);
        }
        return this.createBindings(cmpCls, bindables, named);
    }

    private void retrieveInterfaces(Class<?> cls, Set<Class<?>> interfaces) {
        Class<?>[] ifaces = cls.getInterfaces();
        Class<?> superCls = cls.getSuperclass();
        if (superCls != null) {
            this.retrieveInterfaces(superCls, interfaces);
        }
        if (ifaces.length == 0) {
            return;
        }
        for (Class<?> iface : ifaces) {
            if (iface.getAnnotation(NonBindable.class) != null) continue;
            interfaces.add(iface);
        }
        for (Class<?> iface : ifaces) {
            this.retrieveInterfaces(iface, interfaces);
        }
    }

    private Set<Class<?>> retrieveBindables(Set<Class<?>> interfaces) {
        HashSet result = new HashSet();
        for (Class<?> iface : interfaces) {
            if (iface.getAnnotation(Bindable.class) == null) continue;
            result.add(iface);
        }
        return result;
    }

    private SingletonKey createBindings(Class cmpCls, Set<Class<?>> ifaces, Named named) {
        boolean hasSingletonAnn = cmpCls.getAnnotation(Singleton.class) != null;
        SingletonKey sk = null;
        if (ifaces != null && !ifaces.isEmpty()) {
            for (Class<?> iface : ifaces) {
                if (named != null) {
                    this.binder.bind(iface).annotatedWith((Annotation)named).to(cmpCls);
                    LOGGER.debug("bound iface: {}, named: {}, to: {}", new Object[]{iface.getName(), named.value(), cmpCls.getName()});
                    if (!hasSingletonAnn) continue;
                    sk = new SingletonKey(iface, named);
                    continue;
                }
                this.binder.bind(iface).to(cmpCls);
                LOGGER.debug("bound iface: {}, to: {}", (Object)iface.getName(), (Object)cmpCls.getName());
                if (!hasSingletonAnn) continue;
                sk = new SingletonKey(iface, null);
            }
        } else if (named != null) {
            this.binder.bind(Object.class).annotatedWith((Annotation)named).to(cmpCls);
            LOGGER.debug("bound named: {}, to: {}", (Object)named.value(), (Object)cmpCls.getName());
            if (hasSingletonAnn) {
                sk = new SingletonKey(null, named);
            }
        } else {
            Named dyname = Names.named((String)(cmpCls.getClass().getName() + "#" + Long.toString(System.currentTimeMillis(), 36)));
            this.binder.bind(Object.class).annotatedWith((Annotation)dyname).to(cmpCls);
            LOGGER.debug("bound named: {}, to: {}", (Object)dyname.value(), (Object)cmpCls.getName());
            if (hasSingletonAnn) {
                sk = new SingletonKey(null, named);
            }
        }
        return sk;
    }
}

