/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.polyguice.core.support;

import com.flipkart.polyguice.core.ComponentContext;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultComponentContext
implements ComponentContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultComponentContext.class);
    private Injector injector;

    DefaultComponentContext(Injector injector) {
        this.injector = injector;
    }

    @Override
    public Object getInstance(String name) {
        try {
            return this.injector.getInstance(Key.get(Object.class, (Annotation)Names.named((String)name)));
        }
        catch (Exception exep) {
            LOGGER.warn(exep.getMessage());
            return null;
        }
    }

    @Override
    public <T> T getInstance(Class<T> type) {
        try {
            return (T)this.injector.getInstance(type);
        }
        catch (Exception exep) {
            LOGGER.warn(exep.getMessage());
            return null;
        }
    }

    @Override
    public <T> T getInstance(String name, Class<T> type) {
        try {
            return (T)this.injector.getInstance(Key.get(type, (Annotation)Names.named((String)name)));
        }
        catch (Exception exep) {
            LOGGER.warn(exep.getMessage());
            return null;
        }
    }

    @Override
    public <T> List<T> getInstances(Class<T> type) {
        ArrayList<Object> instances = new ArrayList<Object>();
        List bindings = this.injector.findBindingsByType(TypeLiteral.get(type));
        for (Binding binding : bindings) {
            Key key = binding.getKey();
            instances.add(this.injector.getInstance(key));
        }
        return instances;
    }

    @Override
    public void inject(Object target) {
        this.injector.injectMembers(target);
    }
}

