/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.polyguice.core.support;

import com.flipkart.polyguice.core.ComponentContext;
import com.flipkart.polyguice.core.ConfigurationProvider;
import com.flipkart.polyguice.core.ExternalEntity;
import com.flipkart.polyguice.core.support.DefaultComponentContext;
import com.flipkart.polyguice.core.support.PolyguiceModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Polyguice {
    private static final Logger LOGGER = LoggerFactory.getLogger(Polyguice.class);
    private PolyguiceModule pgmod = new PolyguiceModule();
    private Module[] xmods;
    private Injector injector;
    private ComponentContext compCtxt;
    private boolean prepared = false;

    public Polyguice scanPackage(String name) {
        if (this.prepared) {
            LOGGER.warn("calling scan package after Guice is prepared. Ignoring.");
            return this;
        }
        this.pgmod.scanPackage(name);
        return this;
    }

    public Polyguice modules(Module ... mods) {
        this.xmods = mods;
        return this;
    }

    public Polyguice registerExternal(String name, Object value) {
        if (this.prepared) {
            LOGGER.warn("registering an external entity after Guice is prepared. Ignoring.");
            return this;
        }
        this.pgmod.registerExternal(name, value);
        return this;
    }

    public Polyguice registerExternal(ExternalEntity entity) {
        if (this.prepared) {
            LOGGER.warn("registering an external entity after Guice is prepared. Ignoring.");
            return this;
        }
        this.pgmod.registerExternal(entity.getName(), entity);
        return this;
    }

    public Polyguice registerConfigurationProvider(ConfigurationProvider provider) {
        if (this.prepared) {
            LOGGER.warn("registering a configuration provider after Guice is prepared. Ignoring.");
            return this;
        }
        this.pgmod.registerConfigurationProvider(provider);
        return this;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public Polyguice prepare() {
        if (this.prepared) {
            LOGGER.warn("duplicate call to prepare. Ignoring.");
            return this;
        }
        if (this.xmods == null || this.xmods.length == 0) {
            this.injector = Guice.createInjector((Module[])new Module[]{this.pgmod});
        } else {
            Module[] allModules = new Module[this.xmods.length + 1];
            allModules[0] = this.pgmod;
            System.arraycopy(this.xmods, 0, allModules, 1, this.xmods.length);
            this.injector = Guice.createInjector((Module[])allModules);
        }
        this.compCtxt = new DefaultComponentContext(this.injector);
        if (!this.pgmod.start(this.compCtxt)) {
            throw new RuntimeException("ployguice failed to prepare");
        }
        this.prepared = true;
        LOGGER.debug("polyguice prepared");
        return this;
    }

    public ComponentContext getComponentContext() {
        return this.compCtxt;
    }

    public void stop() {
        System.out.println("stopping polyguice");
        LOGGER.debug("stopping polyguice");
        if (!this.prepared) {
            LOGGER.warn("not prepared. Nothing to stop.");
            return;
        }
        this.pgmod.stop();
    }

    public Polyguice registerShutdownHook() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Polyguice.this.pgmod.stop();
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(runnable));
        return this;
    }
}

