/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.polyguice.core.support;

import com.flipkart.polyguice.core.ComponentContext;
import com.flipkart.polyguice.core.ConfigurationProvider;
import com.flipkart.polyguice.core.support.AutobindManager;
import com.flipkart.polyguice.core.support.ConfigurationInjector;
import com.flipkart.polyguice.core.support.ExternalsInjector;
import com.flipkart.polyguice.core.support.LifecycleManager;
import com.google.inject.AbstractModule;
import java.util.ArrayList;
import java.util.List;

public class PolyguiceModule
extends AbstractModule {
    private List<String> scanPkgNames = new ArrayList<String>();
    private LifecycleManager lifeMan;
    private ExternalsInjector externInject = new ExternalsInjector();
    private ConfigurationInjector confInject = new ConfigurationInjector();

    PolyguiceModule() {
    }

    public void scanPackage(String name) {
        this.scanPkgNames.add(name);
    }

    public void registerExternal(String name, Object value) {
        this.externInject.register(name, value);
    }

    public void registerConfigurationProvider(ConfigurationProvider provider) {
        this.confInject.register(provider);
    }

    public boolean start(ComponentContext compCtxt) {
        this.lifeMan.setComponentContext(compCtxt);
        return this.lifeMan.start();
    }

    public void stop() {
        this.lifeMan.stop();
    }

    protected void configure() {
        AutobindManager abm = new AutobindManager(this.binder());
        String[] pkgNamesArr = this.scanPkgNames.toArray(new String[this.scanPkgNames.size()]);
        abm.autobind(pkgNamesArr);
        this.lifeMan = new LifecycleManager(this.binder());
        this.lifeMan.setExternalsInjector(this.externInject);
        this.lifeMan.setConfigurationInjector(this.confInject);
        this.lifeMan.setProcessors(abm.getComponentProcessors());
        this.lifeMan.setSingletons(abm.getSingletons());
    }
}

