/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.polyguice.core.support;

import com.flipkart.polyguice.core.ComponentContext;
import com.flipkart.polyguice.core.ComponentContextAware;
import com.flipkart.polyguice.core.ComponentProcessor;
import com.flipkart.polyguice.core.Disposable;
import com.flipkart.polyguice.core.InitMethod;
import com.flipkart.polyguice.core.Initializable;
import com.flipkart.polyguice.core.support.ConfigurationInjector;
import com.flipkart.polyguice.core.support.ExternalsInjector;
import com.flipkart.polyguice.core.support.SingletonKey;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.ProvisionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifecycleManager.class);
    private List<String> procNames;
    private List<SingletonKey> singletonKeys;
    private ComponentContext compCtxt;
    private ExternalsInjector externInject;
    private ConfigurationInjector confInject;
    private List<ComponentProcessor> processors;
    private List<Disposable> disposables;
    private boolean startupError;

    LifecycleManager(Binder binder) {
        binder.bindListener((Matcher)new ProvisionMatcher(), new ProvisionListener[]{new ProvisionHandler()});
        binder.bindListener((Matcher)new InjectionMatcher(), (TypeListener)new InjectionTypeHandler());
        this.procNames = new ArrayList<String>();
        this.singletonKeys = new ArrayList<SingletonKey>();
        this.disposables = new ArrayList<Disposable>();
        this.processors = new ArrayList<ComponentProcessor>();
    }

    public void setProcessors(List<String> names) {
        this.procNames.addAll(names);
    }

    public void setSingletons(List<SingletonKey> keys) {
        this.singletonKeys.addAll(keys);
    }

    public void setComponentContext(ComponentContext ctxt) {
        this.compCtxt = ctxt;
    }

    public void setExternalsInjector(ExternalsInjector inject) {
        this.externInject = inject;
    }

    public void setConfigurationInjector(ConfigurationInjector inject) {
        this.confInject = inject;
    }

    public boolean start() {
        LOGGER.debug("starting lifecycle operations");
        this.startupError = false;
        for (String name : this.procNames) {
            ComponentProcessor proc = (ComponentProcessor)this.compCtxt.getInstance(name);
            if (proc != null) {
                this.processors.add(proc);
                LOGGER.debug("loaded component processor {} => {}", (Object)name, (Object)proc.getClass().getName());
                continue;
            }
            LOGGER.error("failed to load component processor: {}", (Object)name);
            return false;
        }
        for (SingletonKey key : this.singletonKeys) {
            Object ston = key.loadComponent(this.compCtxt);
            if (ston == null) {
                LOGGER.error("failed to load singleton: {}", (Object)key);
                return false;
            }
            if (!(ston instanceof Disposable)) continue;
            this.disposables.add((Disposable)ston);
        }
        return !this.startupError;
    }

    public void stop() {
        for (Disposable disp : this.disposables) {
            LOGGER.debug("disposing {}", (Object)disp.getClass().getName());
            try {
                disp.dispose();
            }
            catch (Exception exep) {
                LOGGER.error("while disposing " + disp.getClass().getName(), (Throwable)exep);
            }
        }
    }

    private void doAfterInjection(Object component) {
        if (component instanceof ComponentContextAware) {
            LOGGER.debug("component is context aware. Injecting context.");
            ((ComponentContextAware)component).setComponentContext(this.compCtxt);
        }
        LOGGER.debug("injecting configuration objects on {}", (Object)component.getClass().getName());
        this.confInject.injectComponent(component);
        LOGGER.debug("injecting external objects on {}", (Object)component.getClass().getName());
        this.externInject.injectComponent(component);
        for (ComponentProcessor proc : this.processors) {
            LOGGER.debug("component processor {} => after injection", (Object)proc.getClass().getName());
            proc.afterInjection(component);
        }
    }

    private void doInitialization(Object component) {
        block7: {
            block6: {
                if (!(component instanceof Initializable)) break block6;
                for (ComponentProcessor proc : this.processors) {
                    proc.beforeInitialization(component);
                }
                ((Initializable)component).initialize();
                for (ComponentProcessor proc : this.processors) {
                    proc.afterInitialization(component);
                }
                break block7;
            }
            Method initMthd = this.findInitMethod(component.getClass());
            if (initMthd == null) break block7;
            for (ComponentProcessor proc : this.processors) {
                proc.beforeInitialization(component);
            }
            try {
                initMthd.invoke(component, new Object[0]);
            }
            catch (Exception exep) {
                throw new RuntimeException("error executing init method", exep);
            }
            for (ComponentProcessor proc : this.processors) {
                proc.afterInitialization(component);
            }
        }
    }

    private Method findInitMethod(Class<?> cls) {
        Method[] methods;
        for (Method method : methods = cls.getMethods()) {
            if (method.getAnnotation(InitMethod.class) == null) continue;
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length == 0 && method.getReturnType() == Void.TYPE) {
                return method;
            }
            LOGGER.warn("init-method: {} should have zero args and no return type", (Object)method.getName());
        }
        return null;
    }

    private class InjectionHandler
    implements InjectionListener<Object> {
        private InjectionHandler() {
        }

        public void afterInjection(Object component) {
            LOGGER.debug("injections complete on {}", (Object)component.getClass().getName());
            try {
                LifecycleManager.this.doAfterInjection(component);
            }
            catch (Exception exep) {
                LOGGER.error(exep.toString(), (Throwable)exep);
                LifecycleManager.this.startupError = true;
                throw exep;
            }
        }
    }

    private class InjectionTypeHandler
    implements TypeListener {
        private InjectionTypeHandler() {
        }

        public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
            encounter.register((InjectionListener)new InjectionHandler());
        }
    }

    private class InjectionMatcher
    extends AbstractMatcher<TypeLiteral<?>> {
        private InjectionMatcher() {
        }

        public boolean matches(TypeLiteral<?> tl) {
            return true;
        }
    }

    private class ProvisionHandler
    implements ProvisionListener {
        private ProvisionHandler() {
        }

        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
            Object component = provision.provision();
            try {
                LifecycleManager.this.doInitialization(component);
                LOGGER.debug("provisioned {} -> {}", (Object)component.getClass().getName(), component);
            }
            catch (Exception exep) {
                LOGGER.error(exep.toString(), (Throwable)exep);
                LifecycleManager.this.startupError = true;
                throw exep;
            }
        }
    }

    private class ProvisionMatcher
    extends AbstractMatcher<Binding<?>> {
        private ProvisionMatcher() {
        }

        public boolean matches(Binding<?> binding) {
            return true;
        }
    }
}

