/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.polyguice.core.support;

import com.flipkart.polyguice.core.ComponentContext;
import com.google.inject.name.Named;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SingletonKey {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingletonKey.class);
    private Class<?> type;
    private Named named;

    SingletonKey(Class<?> type, Named named) {
        this.type = type;
        this.named = named;
    }

    public Object loadComponent(ComponentContext compCtxt) {
        if (this.type != null && this.named != null) {
            LOGGER.debug("preloading singleton named: {}, type: {}", (Object)this.named.value(), (Object)this.type.getName());
            return compCtxt.getInstance(this.named.value(), this.type);
        }
        if (this.type != null) {
            LOGGER.debug("preloading singleton type: {}", (Object)this.type.getName());
            return compCtxt.getInstance(this.type);
        }
        if (this.named != null) {
            LOGGER.debug("preloading singleton named: {}", (Object)this.named.value());
            return compCtxt.getInstance(this.named.value());
        }
        return null;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
    }
}

