/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.api;

import com.flipkart.hydra.task.Task;
import com.flipkart.poseidon.core.PoseidonResponse;
import com.flipkart.poseidon.helpers.ObjectMapperHelper;
import com.flipkart.poseidon.internal.OrchestratorDataSource;
import com.flipkart.poseidon.legoset.PoseidonLegoSet;
import com.flipkart.poseidon.mappers.Mapper;
import com.google.common.base.Joiner;
import com.google.common.net.MediaType;
import flipkart.lego.api.entities.Buildable;
import flipkart.lego.api.entities.DataSource;
import flipkart.lego.api.entities.Filter;
import flipkart.lego.api.entities.LegoSet;
import flipkart.lego.api.entities.Request;
import flipkart.lego.api.entities.Response;
import flipkart.lego.api.exceptions.InternalErrorException;
import flipkart.lego.api.exceptions.LegoException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class APIBuildable
implements Buildable {
    private static final String RESPONSE_KEY = "response_key";
    private final PoseidonLegoSet legoSet;
    private final String url;
    private final long timeout;
    private final LinkedHashSet<Filter> filters;
    private final Set<Mapper> mappers;
    private final Map<String, Task> tasks;
    private final Object response;
    private List<Object> mappedBeans;

    public APIBuildable(PoseidonLegoSet legoSet, String url, long timeout, LinkedHashSet<Filter> filters, Set<Mapper> mappers, Map<String, Task> tasks, Object response) {
        this.legoSet = legoSet;
        this.url = url;
        this.timeout = timeout;
        this.filters = filters;
        this.mappers = mappers;
        this.tasks = tasks;
        this.response = response;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, Buildable> getRoutes() {
        HashMap<String, Buildable> routes = new HashMap<String, Buildable>();
        routes.put(this.url, this);
        return routes;
    }

    public long getTimeout() throws LegoException {
        return this.timeout;
    }

    public Map<String, DataSource> getRequiredDataSources(Request request) throws InternalErrorException {
        Map initialParams = (Map)request.getAttribute("params");
        this.mappedBeans = new ArrayList<Object>();
        OrchestratorDataSource dataSource = new OrchestratorDataSource((LegoSet)this.legoSet, initialParams, this.tasks, this.response, this.mappers, this.mappedBeans);
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
        dataSourceMap.put(RESPONSE_KEY, this.legoSet.wrapDataSource((DataSource)dataSource));
        return dataSourceMap;
    }

    public Map<String, DataSource> getOptionalDataSources(Request request) throws LegoException {
        return null;
    }

    public void build(Request request, Response response, Map<String, Object> model) throws InternalErrorException {
        PoseidonResponse poseidonResponse = (PoseidonResponse)response;
        poseidonResponse.setContentType(MediaType.JSON_UTF_8);
        poseidonResponse.addMappedBeans(this.mappedBeans);
        try {
            Object dsResponse = model.get(RESPONSE_KEY);
            String responseStr = dsResponse == null ? "" : ObjectMapperHelper.getMapper().writeValueAsString(dsResponse);
            poseidonResponse.setResponse((Object)responseStr);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public LinkedHashSet<Filter> getFilters(Request request) throws InternalErrorException {
        return this.filters;
    }

    public String getId() throws UnsupportedOperationException {
        return this.getName() + "_" + Joiner.on((String)".").join(this.getVersion());
    }

    public String getName() throws UnsupportedOperationException {
        return "APIBuildable";
    }

    public List<Integer> getVersion() {
        return Arrays.asList(1, 0);
    }
}

