/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.internal;

import com.flipkart.hydra.composer.Composer;
import com.flipkart.hydra.composer.exception.ComposerEvaluationException;
import com.flipkart.hydra.task.entities.WrapperCallable;
import com.flipkart.hydra.task.exception.BadCallableException;
import com.flipkart.poseidon.internal.DataSourceRequest;
import com.flipkart.poseidon.legoset.PoseidonLegoSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import flipkart.lego.api.entities.DataSource;
import flipkart.lego.api.entities.Request;
import flipkart.lego.api.exceptions.ElementNotFoundException;
import flipkart.lego.api.exceptions.LegoSetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

public class DataSourceCallable
extends WrapperCallable {
    private final PoseidonLegoSet legoSet;
    private final String dataSourceName;

    public DataSourceCallable(PoseidonLegoSet legoSet, ExecutorService executor, String dataSourceName, Composer loopComposer, Composer composer, Map<String, Object> values) throws NoSuchMethodException, ComposerEvaluationException {
        super(MoreExecutors.listeningDecorator((ExecutorService)executor), null, loopComposer.compose(values), composer, values);
        this.legoSet = legoSet;
        this.dataSourceName = dataSourceName;
    }

    protected ListenableFuture<Object> getFuture(Object key, Object value) throws Exception {
        HashMap<String, Object> request = new HashMap<String, Object>(this.values);
        request.put("__key", key);
        request.put("__value", value);
        return this.executorService.submit((Callable)this.getDataSource(request));
    }

    private DataSource getDataSource(Map<String, Object> values) throws BadCallableException {
        try {
            Map composedValues = (Map)this.composer.compose(values);
            DataSourceRequest dataSourceRequest = this.getDataSourceRequest(composedValues);
            return this.legoSet.getDataSource(this.dataSourceName, (Request)dataSourceRequest);
        }
        catch (ComposerEvaluationException | ElementNotFoundException | LegoSetException e) {
            throw new BadCallableException("Unable to find datasource - " + this.dataSourceName, e);
        }
    }

    private DataSourceRequest getDataSourceRequest(Map<String, Object> values) {
        DataSourceRequest dataSourceRequest = new DataSourceRequest();
        for (String key : values.keySet()) {
            dataSourceRequest.setAttribute(key, values.get(key));
        }
        return dataSourceRequest;
    }
}

