/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.api;

import com.flipkart.poseidon.api.APILoader;
import com.flipkart.poseidon.api.Configuration;
import com.flipkart.poseidon.helpers.ObjectMapperHelper;
import com.flipkart.poseidon.legoset.PoseidonLegoSet;
import com.flipkart.poseidon.pojos.EndpointPOJO;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class APIManager {
    private static final Logger logger = LoggerFactory.getLogger(APIManager.class);
    private final PoseidonLegoSet legoSet;
    private final Configuration configuration;

    @Autowired
    public APIManager(PoseidonLegoSet legoSet, Configuration configuration) {
        this.legoSet = legoSet;
        this.configuration = configuration;
    }

    public void init() {
        this.updateLegoSet(this.readConfigs());
        new DirectoryWatcher().start();
    }

    private void updateLegoSet(String configs) {
        APILoader loader = new APILoader(this.legoSet, configs, this.configuration);
        try {
            this.legoSet.updateBuildables(loader.getBuildableMap());
        }
        catch (Exception exception) {
            logger.error("Unable to update legoset", (Throwable)exception);
        }
    }

    private String readConfigs() {
        ArrayList<String> validConfigs = new ArrayList<String>();
        Path dir = Paths.get(this.configuration.getApiFilesPath(), new String[0]);
        try (DirectoryStream<Path> files = Files.newDirectoryStream(dir);){
            for (Path entry : files) {
                File file = entry.toFile();
                if (!"json".equals(FilenameUtils.getExtension((String)file.getName()))) continue;
                try {
                    String config = FileUtils.readFileToString((File)file);
                    if (!this.validateConfig(config)) continue;
                    validConfigs.add(config);
                }
                catch (IOException e) {
                    logger.error("Unable to read one of the local config. Filename = [[" + file.getName() + "]]");
                }
            }
        }
        catch (IOException e) {
            logger.error("Local override directory not found.");
        }
        return "[" + Joiner.on((String)",").join(validConfigs) + "]";
    }

    private boolean validateConfig(String config) {
        try {
            ObjectMapperHelper.getMapper().readValue(config, EndpointPOJO.class);
        }
        catch (IOException e) {
            logger.error("Unable to parse one of the config. Content = [[" + config + "]]");
            return false;
        }
        return true;
    }

    class DirectoryWatcher
    extends Thread {
        private WatchService watcher;

        public DirectoryWatcher() {
            try {
                Path dir = Paths.get(APIManager.this.configuration.getApiFilesPath(), new String[0]);
                this.watcher = dir.getFileSystem().newWatchService();
                dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            }
            catch (IOException e) {
                logger.error("Unable to initialize local override directory watcher.");
                this.watcher = null;
            }
        }

        @Override
        public void run() {
            if (this.watcher != null) {
                try {
                    WatchKey watchKey;
                    do {
                        watchKey = this.watcher.take();
                        for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                        }
                        APIManager.this.updateLegoSet(APIManager.this.readConfigs());
                    } while (watchKey.reset());
                    logger.error("Local override directory no longer valid.");
                    watchKey.cancel();
                    this.watcher.close();
                }
                catch (Exception e) {
                    logger.warn("Unable to update local changes", (Throwable)e);
                }
            }
        }
    }
}

