/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.api;

import com.codahale.metrics.Timer;
import com.flipkart.poseidon.api.APILegoSet;
import com.flipkart.poseidon.api.APIManager;
import com.flipkart.poseidon.api.Application;
import com.flipkart.poseidon.core.PoseidonRequest;
import com.flipkart.poseidon.core.PoseidonResponse;
import com.google.common.net.MediaType;
import flipkart.lego.api.entities.LegoSet;
import flipkart.lego.api.entities.Request;
import flipkart.lego.api.entities.Response;
import flipkart.lego.api.exceptions.BadRequestException;
import flipkart.lego.api.exceptions.ElementNotFoundException;
import flipkart.lego.api.exceptions.InternalErrorException;
import flipkart.lego.api.exceptions.ProcessingException;
import flipkart.lego.engine.Lego;
import java.util.concurrent.ExecutorService;
import org.springframework.http.HttpMethod;

public class APIApplication
implements Application {
    private final APIManager apiManager;
    protected final APILegoSet legoSet;
    private Lego lego;

    public APIApplication(APIManager apiManager, APILegoSet legoSet) {
        this.apiManager = apiManager;
        this.legoSet = legoSet;
    }

    public void init(ExecutorService datasourceTPE, ExecutorService filterTPE) {
        this.lego = new Lego((LegoSet)this.legoSet, datasourceTPE, filterTPE);
        this.legoSet.setDataSourceExecutor(datasourceTPE);
        this.apiManager.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(PoseidonRequest request, PoseidonResponse response) throws ElementNotFoundException, BadRequestException, ProcessingException, InternalErrorException {
        HttpMethod method = (HttpMethod)request.getAttribute("method");
        boolean handled = false;
        if (method != null && method.equals((Object)HttpMethod.OPTIONS)) {
            handled = this.handleOptionsRequest(request, response);
        }
        if (!handled) {
            try {
                this.lego.buildResponse((Request)request, (Response)response);
            }
            finally {
                Object timerContext = request.getAttribute("timerContext");
                if (timerContext != null && timerContext instanceof Timer.Context) {
                    ((Timer.Context)timerContext).stop();
                }
            }
        }
    }

    public boolean handleOptionsRequest(PoseidonRequest req, PoseidonResponse resp) throws ElementNotFoundException, BadRequestException, ProcessingException, InternalErrorException {
        return false;
    }

    public MediaType getDefaultMediaType() {
        return MediaType.JSON_UTF_8;
    }
}

