/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.api;

import com.flipkart.poseidon.api.APIBuildable;
import com.flipkart.poseidon.core.PoseidonRequest;
import com.flipkart.poseidon.core.RequestContext;
import com.flipkart.poseidon.ds.trie.Trie;
import com.flipkart.poseidon.legoset.PoseidonLegoSet;
import com.flipkart.poseidon.metrics.Metrics;
import com.flipkart.poseidon.pojos.EndpointPOJO;
import com.flipkart.poseidon.utils.ApiHelper;
import flipkart.lego.api.entities.Buildable;
import flipkart.lego.api.entities.Request;
import flipkart.lego.api.exceptions.ElementNotFoundException;
import flipkart.lego.api.exceptions.LegoSetException;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class APILegoSet
extends PoseidonLegoSet {
    private static final Logger logger = LoggerFactory.getLogger(APILegoSet.class);
    private final int MAX_METHOD_LENGTH = HttpMethod.OPTIONS.asString().length();
    private Trie<String, Buildable> trie = new Trie();

    public void updateBuildables(Map<String, Buildable> buildableMap) {
        for (Map.Entry<String, Buildable> entry : buildableMap.entrySet()) {
            String url = entry.getKey();
            String[] keys = this.getKeysForTrie(url);
            for (int i = 0; i < keys.length; ++i) {
                if (!keys[i].startsWith("{") || !keys[i].endsWith("}")) continue;
                keys[i] = null;
            }
            this.trie.add((String[])keys, entry.getValue());
        }
        this.printPaths();
    }

    private void printPaths() {
        logger.info("Registered URLs: ");
        List<List<String>> paths = this.trie.printAllPaths("/");
        System.out.println("==========================================================================================");
        System.out.println();
        paths.forEach(list -> {
            this.equalizeAndPrintHttpMethod((String)list.get(0));
            list.subList(1, list.size()).forEach(System.out::print);
            System.out.println();
        });
        System.out.println();
        System.out.println("==========================================================================================");
        System.out.println();
    }

    private void equalizeAndPrintHttpMethod(String method) {
        int diff = this.MAX_METHOD_LENGTH - method.length();
        for (int i = 0; i < diff; ++i) {
            method = method + " ";
        }
        System.out.print(method + "\t\t\t\t");
    }

    public Buildable getBuildable(Request request) throws LegoSetException, ElementNotFoundException {
        String name;
        PoseidonRequest poseidonRequest = (PoseidonRequest)request;
        String httpMethod = poseidonRequest.getAttribute("poseidon.method").toString();
        String completeUrl = ApiHelper.getUrlWithHttpMethod(poseidonRequest.getUrl(), httpMethod);
        Buildable buildable = this.trie.get((String[])this.getKeysForTrie(completeUrl));
        if (buildable == null) {
            throw new ElementNotFoundException("Buildable not found for given url: " + poseidonRequest.getUrl());
        }
        if (buildable instanceof APIBuildable) {
            EndpointPOJO pojo = ((APIBuildable)buildable).getPojo();
            RequestContext.set((String)"poseidon.uri", (Object)pojo.getUrl());
            RequestContext.set((String)"poseidon.endpoint.name", (Object)pojo.getName());
        }
        if ((name = buildable.getName()) != null && !name.isEmpty()) {
            poseidonRequest.setAttribute("timerContext", (Object)Metrics.getRegistry().timer("poseidon.api." + name + "." + httpMethod).time());
        }
        return buildable;
    }

    private String[] getKeysForTrie(String url) {
        if (url.startsWith("/")) {
            url = url.replaceFirst("\\/", "");
        }
        return url.split("/");
    }
}

