/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.internal;

import com.flipkart.poseidon.api.Configuration;
import com.flipkart.poseidon.core.PoseidonRequest;
import com.flipkart.poseidon.helper.CallableNameHelper;
import com.flipkart.poseidon.pojos.ParamPOJO;
import com.flipkart.poseidon.pojos.ParamsPOJO;
import com.google.common.base.Joiner;
import flipkart.lego.api.entities.Filter;
import flipkart.lego.api.entities.Request;
import flipkart.lego.api.entities.Response;
import flipkart.lego.api.exceptions.BadRequestException;
import flipkart.lego.api.exceptions.InternalErrorException;
import flipkart.lego.api.exceptions.ProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamValidationFilter
implements Filter {
    private final ParamsPOJO params;
    private final Configuration configuration;
    private static final Logger logger = LoggerFactory.getLogger(ParamValidationFilter.class);

    public ParamValidationFilter() {
        this(new ParamsPOJO(), null);
    }

    public ParamValidationFilter(ParamsPOJO params, Configuration configuration) {
        this.params = params;
        this.configuration = configuration;
    }

    public void filterRequest(Request request, Response response) throws InternalErrorException, BadRequestException, ProcessingException {
        PoseidonRequest poseidonRequest = (PoseidonRequest)request;
        HashMap<String, Object> parsedParams = new HashMap<String, Object>();
        if (this.params != null) {
            parsedParams.putAll(this.validateParams(poseidonRequest, this.params.getRequired(), true));
            parsedParams.putAll(this.validateParams(poseidonRequest, this.params.getOptional(), false));
        }
        poseidonRequest.setAttribute("params", parsedParams);
    }

    public void filterResponse(Request request, Response response) throws InternalErrorException, BadRequestException, ProcessingException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, Object> validateParams(PoseidonRequest poseidonRequest, ParamPOJO[] params, boolean failOnMissingValue) throws BadRequestException {
        HashMap<String, Object> parsedParams = new HashMap<String, Object>();
        if (params == null) return parsedParams;
        for (ParamPOJO param : params) {
            String name = param.getName();
            String internalName = param.getInternalName();
            ParamPOJO.DataType datatype = param.getDatatype();
            Object defaultValue = param.getDefaultValue();
            String separator = param.getSeparator();
            boolean multivalue = param.getMultivalue() || separator != null;
            boolean isBodyRequest = param.isBody();
            boolean isHeader = param.isHeader();
            boolean isPathParam = param.isPathparam();
            Object value = null;
            if (isHeader) {
                String attribute = poseidonRequest.getHeader(name);
                if (failOnMissingValue && attribute == null) {
                    throw new BadRequestException("Missing header : " + name);
                }
                value = !failOnMissingValue && attribute == null && defaultValue != null ? defaultValue : attribute;
            } else if (isBodyRequest) {
                String bodyString = (String)poseidonRequest.getAttribute("body");
                if (!StringUtils.isEmpty((CharSequence)bodyString)) {
                    try {
                        value = (param.getJavatype() == null || param.getJavatype().isEmpty()) && param.getDatatype() == null ? bodyString : this.configuration.getObjectMapper().readValue(bodyString, Class.forName(param.getJavatype()));
                    }
                    catch (IOException e) {
                        logger.error("Error in reading body : {}", (Object)e.getMessage());
                    }
                    catch (ClassNotFoundException e) {
                        logger.error("Error in finding class for body : {}", (Object)e.getMessage());
                    }
                }
                if (failOnMissingValue && value == null) {
                    throw new BadRequestException("Request Body is either missing or invalid for : " + name);
                }
            } else if (isPathParam) {
                int pos = param.getPosition();
                String[] splitUrl = poseidonRequest.getUrl().split("/");
                if (splitUrl.length <= pos) throw new BadRequestException("Missing path parameter : " + name);
                value = splitUrl[pos];
            } else if (param.isFile()) {
                value = poseidonRequest.getAttribute(name);
                if (failOnMissingValue && value == null) {
                    throw new BadRequestException("Missing parameter : " + name);
                }
            } else {
                String[] attribute = poseidonRequest.getAttribute(name);
                if (failOnMissingValue && attribute == null) {
                    throw new BadRequestException("Missing parameter : " + name);
                }
                if (multivalue && separator != null && attribute != null) {
                    attribute = ((String[])attribute)[0].split(separator);
                }
                value = !failOnMissingValue && attribute == null && defaultValue != null ? defaultValue : this.parseParamValues(name, attribute, datatype, multivalue);
            }
            if (internalName != null && !internalName.isEmpty()) {
                parsedParams.put(internalName, value);
                continue;
            }
            parsedParams.put(name, value);
        }
        return parsedParams;
    }

    private Object parseParamValues(String name, String[] values, ParamPOJO.DataType datatype, boolean multivalue) throws BadRequestException {
        try {
            if (values != null) {
                if (!multivalue && values.length > 1) {
                    throw new BadRequestException("Multiple values provided for parameter : " + name);
                }
                List parsedValues = this.getValues(values, datatype);
                return multivalue ? parsedValues : parsedValues.get(0);
            }
            return null;
        }
        catch (NumberFormatException e) {
            throw new BadRequestException("Incorrect value provided for parameter : " + name + " (Expected value - " + (Object)((Object)datatype) + ")");
        }
    }

    private List getValues(String[] values, ParamPOJO.DataType datatype) {
        switch (datatype) {
            case NUMBER: {
                return this.getDoubleValues(values);
            }
            case INTEGER: {
                return this.getIntegerValues(values);
            }
            case BOOLEAN: {
                return this.getBooleanValues(values);
            }
        }
        return this.getStringValues(values);
    }

    private List<Double> getDoubleValues(String[] values) {
        ArrayList<Double> doubleValues = new ArrayList<Double>();
        for (String value : values) {
            doubleValues.add(Double.parseDouble(value));
        }
        return doubleValues;
    }

    private List<Integer> getIntegerValues(String[] values) {
        ArrayList<Integer> integerValues = new ArrayList<Integer>();
        for (String value : values) {
            integerValues.add(Integer.parseInt(value));
        }
        return integerValues;
    }

    private List<Boolean> getBooleanValues(String[] values) {
        ArrayList<Boolean> booleanValues = new ArrayList<Boolean>();
        for (String value : values) {
            booleanValues.add(Boolean.parseBoolean(value));
        }
        return booleanValues;
    }

    private List<String> getStringValues(String[] values) {
        return Arrays.asList(values);
    }

    public String getShortDescription() {
        return "Internal parameter filter to validate and extract the mentioned parameters from the request.";
    }

    public String getDescription() {
        return this.getShortDescription();
    }

    public String getId() throws UnsupportedOperationException {
        return this.getName() + "_" + Joiner.on((String)".").join(this.getVersion());
    }

    public String getName() throws UnsupportedOperationException {
        return CallableNameHelper.canonicalName((String)this.getClass().getSimpleName(), (String)"Filter", (String)"Filter");
    }

    public List<Integer> getVersion() throws UnsupportedOperationException {
        return Arrays.asList(1, 0, 0);
    }
}

