/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.validator;

import com.flipkart.poseidon.pojos.EndpointPOJO;
import com.flipkart.poseidon.validator.ValidatorUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FieldValidator {
    private static final List<String> notNullFields = Arrays.asList("tasks", "httpMethod", "url");

    public static List<String> validate(EndpointPOJO pojo) throws IllegalAccessException {
        Field[] fields;
        ArrayList<String> errors = new ArrayList<String>();
        for (Field field : fields = EndpointPOJO.class.getDeclaredFields()) {
            if (!notNullFields.contains(field.getName())) continue;
            field.setAccessible(true);
            Object value = field.get(pojo);
            if (value != null && !ValidatorUtils.isEmpty(value)) continue;
            errors.add("No " + field.getName() + " defined");
        }
        errors.addAll(FieldValidator.validateUrl(pojo.getUrl()));
        errors.addAll(FieldValidator.validateTimeout(pojo.getTimeout()));
        return errors;
    }

    public static List<String> validateUrl(String value) {
        ArrayList<String> errors = new ArrayList<String>();
        if (value != null) {
            if (value.trim().isEmpty()) {
                errors.add("Invalid Url. Cannot be Empty.");
            } else {
                for (int i = 0; i < value.length() - 1; ++i) {
                    if (value.charAt(i) != '/' || value.charAt(i + 1) != '/') continue;
                    errors.add("Invalid Url. Cannot contain two '/'s consecutively");
                }
            }
        }
        return errors;
    }

    public static List<String> validateTimeout(long value) {
        ArrayList<String> errors = new ArrayList<String>();
        if (value <= 0L) {
            errors.add("No or invalid timeout defined.");
        }
        return errors;
    }
}

