/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.flipkart.hydra.composer.exception.ComposerInstantiationException;
import com.flipkart.hydra.task.Task;
import com.flipkart.poseidon.api.APIBuildable;
import com.flipkart.poseidon.api.Configuration;
import com.flipkart.poseidon.helpers.ObjectMapperHelper;
import com.flipkart.poseidon.internal.APITask;
import com.flipkart.poseidon.legoset.PoseidonLegoSet;
import com.flipkart.poseidon.pojos.EndpointPOJO;
import com.flipkart.poseidon.pojos.TaskPOJO;
import com.flipkart.poseidon.utils.ApiHelper;
import flipkart.lego.api.entities.Buildable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APILoader {
    private static final Logger logger = LoggerFactory.getLogger(APILoader.class);
    private final PoseidonLegoSet legoSet;
    private List<EndpointPOJO> pojos = new ArrayList<EndpointPOJO>();
    private final Configuration configuration;

    public APILoader(PoseidonLegoSet legoSet, String config, Configuration configuration) {
        this.legoSet = legoSet;
        this.configuration = configuration;
        try {
            this.loadBuildables(config);
        }
        catch (Exception exception) {
            logger.error("Buildables loading failed: {}", (Throwable)exception);
        }
    }

    public Map<String, Buildable> getBuildableMap() {
        HashMap<String, Buildable> buildables = new HashMap<String, Buildable>();
        for (EndpointPOJO pojo : this.pojos) {
            try {
                if (pojo.getHttpMethod() == null) {
                    throw new UnsupportedOperationException("HttpMethod cannot be null");
                }
                String completeUrl = ApiHelper.getUrlWithHttpMethod(pojo.getUrl(), pojo.getHttpMethod().toString());
                if (buildables.containsKey(completeUrl)) {
                    logger.error("******* More than one Buildable defined for api: \"" + pojo.getUrl() + "\", all except first occurrences will be ignored. *******");
                    continue;
                }
                APIBuildable apiBuildable = new APIBuildable(this.legoSet, pojo, this.configuration, this.getCalls(pojo.getTasks()));
                buildables.put(completeUrl, apiBuildable);
            }
            catch (Throwable error) {
                logger.error("Buildable loading failed for api: " + pojo.getUrl(), error);
            }
        }
        return buildables;
    }

    private void loadBuildables(String config) throws Exception {
        JsonNode nodes = ObjectMapperHelper.getMapper().readTree(config);
        if (!nodes.isArray()) {
            throw new Exception("Config is not an array of buildables");
        }
        for (JsonNode node : nodes) {
            try {
                this.pojos.add((EndpointPOJO)ObjectMapperHelper.getMapper().readValue(node.toString(), EndpointPOJO.class));
            }
            catch (Exception exception) {
                logger.error("Error in de-serializing a config: " + node.toString(), (Throwable)exception);
            }
        }
    }

    private Map<String, Task> getCalls(Map<String, TaskPOJO> sources) throws ComposerInstantiationException {
        HashMap<String, Task> tasks = new HashMap<String, Task>();
        for (String key : sources.keySet()) {
            TaskPOJO dataSourcePOJO = sources.get(key);
            String name = dataSourcePOJO.getName();
            Map<String, Object> context = dataSourcePOJO.getContext();
            String loopOverContext = dataSourcePOJO.getLoopOver();
            tasks.put(key, (Task)new APITask(this.legoSet, name, loopOverContext, context));
        }
        return tasks;
    }
}

