/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.validator;

import com.flipkart.poseidon.api.APIManager;
import com.flipkart.poseidon.helpers.ObjectMapperHelper;
import com.flipkart.poseidon.pojos.EndpointPOJO;
import com.flipkart.poseidon.validator.EndpointValidator;
import com.flipkart.poseidon.validator.ValidatorUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIValidator {
    private static final Logger logger = LoggerFactory.getLogger(APIValidator.class);
    private static final List<EndpointPOJO> pojos = new ArrayList<EndpointPOJO>();

    public static void main(String[] args) {
        Path dir = Paths.get(args[0], new String[0]);
        ArrayList<String> validConfigs = new ArrayList<String>();
        try {
            APIManager.scanAndAdd(dir, validConfigs);
            for (String config : validConfigs) {
                pojos.add((EndpointPOJO)ObjectMapperHelper.getMapper().readValue(config, EndpointPOJO.class));
            }
            HashMap<String, List<String>> errors = new HashMap<String, List<String>>();
            for (EndpointPOJO pojo : pojos) {
                List<String> pojoErrors = EndpointValidator.validate(pojo);
                if (pojoErrors.isEmpty()) continue;
                errors.put(pojo.getHttpMethod() + " " + pojo.getUrl(), pojoErrors);
            }
            if (!errors.isEmpty()) {
                logger.error(ValidatorUtils.getFormattedErrorMessages(errors));
                System.exit(-1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

