/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon;

import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.fibers.Suspendable;
import co.paralleluniverse.strands.channels.Channel;
import co.paralleluniverse.strands.channels.Channels;
import flipkart.lego.concurrency.executors.CompositeCompletionService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CompositeFiberCompletionService
implements CompositeCompletionService {
    private final Channel<Future> channel = Channels.newChannel((int)-1);

    @Suspendable
    public Future submit(final Callable callable) {
        return new Fiber(){

            protected Object run() throws SuspendExecution, InterruptedException {
                try {
                    Object v = callable.call();
                    return v;
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
                finally {
                    CompositeFiberCompletionService.this.channel.send((Object)this);
                }
            }
        }.start();
    }

    @Suspendable
    public List<Future> submit(List<Callable> callables) {
        ArrayList<Future> futures = new ArrayList<Future>();
        for (Callable callable : callables) {
            futures.add(this.submit(callable));
        }
        return futures;
    }

    @Suspendable
    public void wait(List<Future> futures, long timeout) throws TimeoutException, InterruptedException, ExecutionException {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < futures.size(); ++i) {
            long currentTime = System.currentTimeMillis();
            long elapsedTime = currentTime - startTime;
            long remainingTime = timeout - elapsedTime;
            if (remainingTime <= 0L) continue;
            try {
                Future future = (Future)this.channel.receive(remainingTime, TimeUnit.MILLISECONDS);
                if (future == null) {
                    throw new TimeoutException();
                }
                future.get();
                continue;
            }
            catch (SuspendExecution suspendExecution) {
                suspendExecution.printStackTrace();
            }
        }
    }

    public void shutdown() {
        this.channel.close();
    }
}

