/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.api;

import com.flipkart.poseidon.Poseidon;
import com.flipkart.poseidon.api.APIBuildable;
import com.flipkart.poseidon.core.PoseidonRequest;
import com.flipkart.poseidon.core.RequestContext;
import com.flipkart.poseidon.ds.trie.KeyWrapper;
import com.flipkart.poseidon.ds.trie.Trie;
import com.flipkart.poseidon.legoset.PoseidonLegoSet;
import com.flipkart.poseidon.metrics.Metrics;
import com.flipkart.poseidon.pojos.EndpointPOJO;
import com.flipkart.poseidon.serviceclients.ServiceContext;
import com.flipkart.poseidon.utils.ApiHelper;
import flipkart.lego.api.entities.Buildable;
import flipkart.lego.api.entities.Request;
import flipkart.lego.api.exceptions.ElementNotFoundException;
import flipkart.lego.api.exceptions.LegoSetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class APILegoSet
extends PoseidonLegoSet {
    private static final Logger logger = LoggerFactory.getLogger(APILegoSet.class);
    private final int MAX_METHOD_LENGTH = HttpMethod.OPTIONS.asString().length();
    private Trie<String, Buildable> trie = new Trie();

    public void updateBuildables(Map<String, Buildable> buildableMap) {
        for (Map.Entry<String, Buildable> entry : buildableMap.entrySet()) {
            String url = entry.getKey();
            this.trie.add(APILegoSet.getKeysForTrie(url), entry.getValue());
        }
        this.printPaths();
    }

    private void printPaths() {
        List<List<String>> paths = this.trie.printAllPaths("/");
        StringBuilder builder = new StringBuilder();
        builder.append("Registered URLs: \n");
        builder.append("==========================================================================================\n");
        builder.append("\n");
        paths.forEach(list -> {
            this.equalizeAndPrintHttpMethod((String)list.get(0), builder);
            list.subList(1, list.size()).forEach(builder::append);
            builder.append("\n");
        });
        builder.append("\n");
        builder.append("==========================================================================================\n");
        Poseidon.STARTUP_LOGGER.info(builder.toString());
    }

    private void equalizeAndPrintHttpMethod(String method, StringBuilder builder) {
        int diff = this.MAX_METHOD_LENGTH - method.length();
        for (int i = 0; i < diff; ++i) {
            method = method + " ";
        }
        builder.append(method + "\t\t\t\t");
    }

    public Buildable getBuildable(Request request) throws LegoSetException, ElementNotFoundException {
        PoseidonRequest poseidonRequest = (PoseidonRequest)request;
        String httpMethod = poseidonRequest.getAttribute("poseidon.method").toString();
        String completeUrl = ApiHelper.getUrlWithHttpMethod(poseidonRequest.getUrl(), httpMethod);
        Buildable buildable = this.trie.get((String[])APILegoSet.getKeysArrayForTrie(completeUrl));
        if (buildable == null) {
            throw new ElementNotFoundException("Buildable not found for given url: " + poseidonRequest.getUrl());
        }
        if (buildable instanceof APIBuildable) {
            EndpointPOJO pojo = ((APIBuildable)buildable).getPojo();
            RequestContext.set((String)"poseidon.uri", (Object)pojo.getUrl());
            RequestContext.set((String)"poseidon.endpoint.name", (Object)pojo.getName());
            RequestContext.set((String)"poseidon.endpoint.method", (Object)pojo.getHttpMethod());
            ServiceContext.set((String)"poseidon.endpoint.name", (Object)pojo.getName());
            String name = pojo.getName();
            if (name != null && !name.isEmpty()) {
                poseidonRequest.setAttribute("timerContext", (Object)Metrics.getRegistry().timer("poseidon.api." + name + "." + httpMethod).time());
            }
        }
        return buildable;
    }

    public static List<KeyWrapper<String>> getKeysForTrie(String url) {
        List<KeyWrapper<String>> wrappers = Arrays.stream(APILegoSet.getKeysArrayForTrie(url)).map(KeyWrapper::new).collect(Collectors.toList());
        for (KeyWrapper keyWrapper : wrappers) {
            if (((String)keyWrapper.key).startsWith("{") && ((String)keyWrapper.key).endsWith("}")) {
                keyWrapper.key = null;
                keyWrapper.wildCard = true;
                continue;
            }
            if (!((String)keyWrapper.key).startsWith("*") || !((String)keyWrapper.key).endsWith("*")) continue;
            keyWrapper.key = null;
            keyWrapper.greedyWildCard = true;
        }
        return wrappers;
    }

    private static String[] getKeysArrayForTrie(String url) {
        if (url.startsWith("/")) {
            url = url.replaceFirst("\\/", "");
        }
        return url.split("/");
    }
}

