/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.validator;

import com.flipkart.poseidon.datasources.RequestAttribute;
import com.flipkart.poseidon.validator.ValidatorUtils;
import flipkart.lego.api.entities.DataSource;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

public class DatasourceValidator {
    public static List<String> validate(Class<? extends DataSource<?>> dsClass) {
        Constructor<?>[] declaredConstructors;
        ArrayList<String> errors = new ArrayList<String>();
        int injectableConstructorCount = 0;
        for (Constructor<?> constructor : declaredConstructors = dsClass.getDeclaredConstructors()) {
            if (constructor.getParameterCount() == 2) continue;
            if (!constructor.isAnnotationPresent(Inject.class)) {
                errors.add("Injectable constructor" + constructor.toGenericString() + "not annotated with @Inject");
                continue;
            }
            ++injectableConstructorCount;
            Parameter[] parameters = constructor.getParameters();
            HashSet<String> datasourceRequestAttributes = new HashSet<String>();
            for (Parameter parameter : parameters) {
                String attribute;
                boolean added;
                RequestAttribute requestAttribute = parameter.getAnnotation(RequestAttribute.class);
                if (requestAttribute == null || (added = datasourceRequestAttributes.add(attribute = Optional.of(requestAttribute.value()).filter(StringUtils::isNotEmpty).orElse(parameter.getName())))) continue;
                errors.add("RequestAttribute: " + ValidatorUtils.braced(attribute) + " is used twice");
            }
        }
        if (injectableConstructorCount > 1) {
            errors.add("More than 1 injectable constructor defined");
        }
        return errors;
    }
}

