/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.validator;

import com.flipkart.poseidon.datasources.RequestAttribute;
import com.flipkart.poseidon.pojos.ParamPOJO;
import com.flipkart.poseidon.pojos.ParamsPOJO;
import com.flipkart.poseidon.pojos.TaskPOJO;
import com.flipkart.poseidon.validator.ValidatorUtils;
import flipkart.lego.api.entities.DataSource;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskValidator {
    private static final Logger logger = LoggerFactory.getLogger(TaskValidator.class);

    public static List<String> validate(Map<String, TaskPOJO> tasks, ParamsPOJO params, Map<String, Class<? extends DataSource<?>>> datasources, boolean validateDataSources) {
        ArrayList<String> errors = new ArrayList<String>();
        boolean skipUnusedFieldValidation = Boolean.valueOf(System.getProperty("poseidon.validator.skip.unused_params"));
        for (Map.Entry<String, TaskPOJO> entry : tasks.entrySet()) {
            List<Constructor<DataSource<?>>> injectableConstructors;
            String taskName = entry.getKey();
            TaskPOJO task = entry.getValue();
            Class<? extends DataSource<?>> dsClass = datasources.get(task.getName());
            if (ValidatorUtils.isNullOrEmpty(task.getName())) {
                errors.add("No datasource defined for Task: " + ValidatorUtils.braced(taskName));
            } else if (dsClass == null && validateDataSources) {
                errors.add("Datasource used does not exist for Task: " + ValidatorUtils.braced(taskName));
            }
            HashSet<String> datasourceRequestAttributes = new HashSet<String>();
            if (dsClass != null && validateDataSources && !(injectableConstructors = TaskValidator.findInjectableConstructors(dsClass)).isEmpty()) {
                Parameter[] parameters;
                Constructor<DataSource<?>> constructor = injectableConstructors.get(0);
                for (Parameter parameter : parameters = constructor.getParameters()) {
                    RequestAttribute requestAttribute = parameter.getAnnotation(RequestAttribute.class);
                    if (requestAttribute == null) continue;
                    datasourceRequestAttributes.add(Optional.of(requestAttribute.value()).filter(StringUtils::isNotEmpty).orElse(parameter.getName()));
                }
            }
            Map context = Optional.ofNullable(task.getContext()).orElse(new HashMap());
            for (Map.Entry contextEntry : context.entrySet()) {
                boolean isExpression;
                boolean isOptional;
                Object contextEntryValue;
                String key = (String)contextEntry.getKey();
                if (!datasourceRequestAttributes.contains(key)) {
                    if (!skipUnusedFieldValidation) {
                        errors.add("ContextParam: " + ValidatorUtils.braced(key) + " used in Task: " + ValidatorUtils.braced(taskName) + " is not used in the Datasource");
                    } else {
                        logger.warn("ContextParam: {} used in Task: {} is not used in the Datasource", (Object)ValidatorUtils.braced(key), (Object)ValidatorUtils.braced(taskName));
                    }
                }
                if (!((contextEntryValue = contextEntry.getValue()) instanceof String)) continue;
                String fullContextParam = ValidatorUtils.stripBraces((String)contextEntryValue);
                boolean bl = isOptional = fullContextParam.charAt(0) == '#';
                if (isOptional) {
                    fullContextParam = fullContextParam.substring(1);
                }
                if (!(isExpression = fullContextParam.charAt(0) == '$')) continue;
                fullContextParam = fullContextParam.substring(1);
                String contextParam = fullContextParam.split("\\.")[0];
                boolean located = false;
                if (contextParam == null || contextParam.isEmpty()) continue;
                if (params != null) {
                    if (params.getRequired() != null) {
                        for (ParamPOJO param : params.getRequired()) {
                            if (!contextParam.equals(param.getName()) && !contextParam.equals(param.getInternalName())) continue;
                            located = true;
                            if (!isOptional) continue;
                            errors.add("Param: " + ValidatorUtils.braced(param.getName()) + " used in Task: " + ValidatorUtils.braced(taskName) + " is not optional");
                        }
                    }
                    if (params.getOptional() != null) {
                        for (ParamPOJO param : params.getOptional()) {
                            if (!contextParam.equals(param.getName()) && !contextParam.equals(param.getInternalName())) continue;
                            located = true;
                            if (isOptional || param.getDefaultValue() != null) continue;
                            errors.add("Param: " + ValidatorUtils.braced(param.getName()) + " used in Task: " + ValidatorUtils.braced(taskName) + " is optional. Add a '#'");
                        }
                    }
                }
                for (String param : tasks.keySet()) {
                    if (!contextParam.equals(param)) continue;
                    located = true;
                }
                if (located && !contextParam.equals(taskName)) continue;
                errors.add("Param: " + ValidatorUtils.braced(contextParam) + " used in Task: " + ValidatorUtils.braced(taskName) + " is not defined anywhere");
            }
        }
        return errors;
    }

    private static <T> List<Constructor<T>> findInjectableConstructors(Class<T> klass) {
        Constructor<?>[] declaredConstructors = klass.getDeclaredConstructors();
        List<Constructor<T>> injectableConstructors = Arrays.stream(declaredConstructors).filter(c -> c.isAnnotationPresent(Inject.class)).collect(Collectors.toList());
        if (injectableConstructors.size() > 1) {
            throw new UnsupportedOperationException(klass.getName() + " has more than one injectable constructor");
        }
        return injectableConstructors;
    }
}

