/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.internal;

import com.fasterxml.jackson.databind.JavaType;
import com.flipkart.poseidon.api.Configuration;
import com.flipkart.poseidon.core.PoseidonRequest;
import com.flipkart.poseidon.core.RequestContext;
import com.flipkart.poseidon.model.annotations.Description;
import com.flipkart.poseidon.model.annotations.Name;
import com.flipkart.poseidon.model.annotations.Trace;
import com.flipkart.poseidon.model.annotations.Version;
import com.flipkart.poseidon.pojos.ParamPOJO;
import com.flipkart.poseidon.pojos.ParamsPOJO;
import flipkart.lego.api.entities.Filter;
import flipkart.lego.api.entities.Request;
import flipkart.lego.api.entities.Response;
import flipkart.lego.api.exceptions.BadRequestException;
import flipkart.lego.api.exceptions.InternalErrorException;
import flipkart.lego.api.exceptions.ProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Trace(value=false)
@Name(value="ParamValidationFilter")
@Version(major=1, minor=0, patch=0)
@Description(value="Poseidon filter to validate API parameters")
public class ParamValidationFilter
implements Filter {
    private final ParamsPOJO params;
    private final Configuration configuration;
    private static final Logger logger = LoggerFactory.getLogger(ParamValidationFilter.class);

    public ParamValidationFilter() {
        this(new ParamsPOJO(), null);
    }

    public ParamValidationFilter(ParamsPOJO params, Configuration configuration) {
        this.params = params;
        this.configuration = configuration;
    }

    public void filterRequest(Request request, Response response) throws InternalErrorException, BadRequestException, ProcessingException {
        PoseidonRequest poseidonRequest = (PoseidonRequest)request;
        HashMap<String, Object> parsedParams = new HashMap<String, Object>();
        if (this.params != null) {
            parsedParams.putAll(this.validateParams(poseidonRequest, this.params.getRequired(), true));
            parsedParams.putAll(this.validateParams(poseidonRequest, this.params.getOptional(), false));
        }
        poseidonRequest.setAttribute("params", parsedParams);
    }

    public void filterResponse(Request request, Response response) throws InternalErrorException, BadRequestException, ProcessingException {
    }

    private Map<String, Object> validateParams(PoseidonRequest poseidonRequest, ParamPOJO[] params, boolean failOnMissingValue) throws BadRequestException {
        HashMap<String, Object> parsedParams = new HashMap<String, Object>();
        if (params != null) {
            ArrayList<ParamPOJO> pathParams = new ArrayList<ParamPOJO>();
            for (ParamPOJO param : params) {
                String[] attribute;
                String name = param.getName();
                String internalName = param.getInternalName();
                ParamPOJO.DataType datatype = param.getDatatype();
                Object defaultValue = param.getDefaultValue();
                String separator = param.getSeparator();
                boolean multivalue = param.getMultivalue() || separator != null;
                boolean isBodyRequest = param.isBody();
                boolean isHeader = param.isHeader();
                boolean isPathParam = param.isPathparam();
                Object value = null;
                if (isHeader) {
                    attribute = poseidonRequest.getHeader(name);
                    if (failOnMissingValue && attribute == null) {
                        throw new BadRequestException("Missing header : " + name);
                    }
                    value = !failOnMissingValue && attribute == null && defaultValue != null ? defaultValue : this.parseParamValues(name, new String[]{attribute}, datatype, multivalue, param.getJavaType());
                } else if (isBodyRequest) {
                    String bodyString = (String)poseidonRequest.getAttribute("body");
                    if (!StringUtils.isEmpty((CharSequence)bodyString)) {
                        try {
                            value = param.getJavaType() == null && param.getDatatype() == null ? bodyString : this.configuration.getObjectMapper().readValue(bodyString, param.getJavaType());
                        }
                        catch (IOException e) {
                            logger.error("Error in reading body : {}", (Object)e.getMessage());
                        }
                    }
                    if (failOnMissingValue && value == null) {
                        throw new BadRequestException("Request Body is either missing or invalid for : " + name);
                    }
                } else if (isPathParam) {
                    param.setGreedyPosition(param.getPosition());
                    pathParams.add(param);
                } else if (param.isFile()) {
                    value = poseidonRequest.getAttribute(name);
                    if (failOnMissingValue && value == null) {
                        throw new BadRequestException("Missing parameter : " + name);
                    }
                } else {
                    attribute = poseidonRequest.getAttribute(name);
                    if (failOnMissingValue && attribute == null) {
                        throw new BadRequestException("Missing parameter : " + name);
                    }
                    if (multivalue && separator != null && attribute != null) {
                        attribute = ((String[])attribute)[0].split(separator);
                    }
                    value = !failOnMissingValue && attribute == null && defaultValue != null ? defaultValue : this.parseParamValues(name, attribute, datatype, multivalue, param.getJavaType());
                }
                if (internalName != null && !internalName.isEmpty()) {
                    parsedParams.put(internalName, value);
                    continue;
                }
                parsedParams.put(name, value);
            }
            if (!pathParams.isEmpty()) {
                pathParams.sort((a, b) -> a.getPosition() - b.getPosition());
                for (int i = 0; i < pathParams.size(); ++i) {
                    boolean isGreedyParam;
                    ParamPOJO param = (ParamPOJO)pathParams.get(i);
                    String name = param.getName();
                    String internalName = param.getInternalName();
                    String value = null;
                    ParamPOJO.DataType datatype = param.getDatatype();
                    int pos = param.getPosition();
                    int greedyPos = param.getGreedyPosition();
                    String[] splitUrl = poseidonRequest.getUrl().split("/");
                    String[] splitActual = ((String)RequestContext.get((String)"poseidon.uri")).split("/");
                    if (pos >= splitUrl.length) {
                        throw new BadRequestException("Missing path parameter : " + name);
                    }
                    boolean bl = isGreedyParam = splitActual[pos].length() >= 2 && splitActual[pos].startsWith("*") && splitActual[pos].endsWith("*");
                    if (splitUrl.length == splitActual.length || !isGreedyParam) {
                        value = splitUrl[greedyPos];
                    } else if (isGreedyParam) {
                        int j;
                        int nextPos = greedyPos + 1;
                        if (pos == splitActual.length - 1) {
                            nextPos = splitUrl.length;
                        } else {
                            for (j = greedyPos + 1; j < splitUrl.length; ++j) {
                                if (!splitActual[pos + 1].equals(splitUrl[j])) continue;
                                nextPos = j;
                                break;
                            }
                        }
                        for (j = i + 1; j < pathParams.size(); ++j) {
                            ParamPOJO nextParam = (ParamPOJO)pathParams.get(j);
                            nextParam.setGreedyPosition(nextParam.getGreedyPosition() + (nextPos - greedyPos - 1));
                        }
                        value = this.getGreedyPathParam(greedyPos, nextPos, splitUrl);
                    }
                    if (value == null) {
                        throw new BadRequestException("Missing path parameter : " + name);
                    }
                    Object convertedValue = this.parseParamValues(name, new String[]{value}, datatype, false, param.getJavaType());
                    if (internalName != null && !internalName.isEmpty()) {
                        parsedParams.put(internalName, convertedValue);
                        continue;
                    }
                    parsedParams.put(name, convertedValue);
                }
            }
        }
        return parsedParams;
    }

    private String getGreedyPathParam(int start, int end, String[] url) {
        StringBuilder builder = new StringBuilder();
        for (int i = start; i < end; ++i) {
            builder.append(url[i]).append("/");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    private Object parseParamValues(String name, String[] values, ParamPOJO.DataType datatype, boolean multivalue, JavaType javaType) throws BadRequestException {
        try {
            if (values != null) {
                if (!multivalue && values.length > 1) {
                    throw new BadRequestException("Multiple values provided for parameter : " + name);
                }
                List parsedValues = this.getValues(values, datatype, javaType);
                return multivalue ? parsedValues : parsedValues.get(0);
            }
            return null;
        }
        catch (NumberFormatException e) {
            throw new BadRequestException("Incorrect value provided for parameter : " + name + " (Expected value - " + (Object)((Object)datatype) + ")");
        }
    }

    private List getValues(String[] values, ParamPOJO.DataType datatype, JavaType javaType) throws BadRequestException {
        switch (datatype) {
            case NUMBER: {
                return this.getDoubleValues(values);
            }
            case INTEGER: {
                return this.getIntegerValues(values);
            }
            case BOOLEAN: {
                return this.getBooleanValues(values);
            }
            case ENUM: {
                return this.getEnumValues(values, javaType);
            }
        }
        return this.getStringValues(values);
    }

    private List<Double> getDoubleValues(String[] values) {
        ArrayList<Double> doubleValues = new ArrayList<Double>();
        for (String value : values) {
            doubleValues.add(Double.parseDouble(value));
        }
        return doubleValues;
    }

    private List<Integer> getIntegerValues(String[] values) {
        ArrayList<Integer> integerValues = new ArrayList<Integer>();
        for (String value : values) {
            integerValues.add(Integer.parseInt(value));
        }
        return integerValues;
    }

    private List<Boolean> getBooleanValues(String[] values) {
        ArrayList<Boolean> booleanValues = new ArrayList<Boolean>();
        for (String value : values) {
            booleanValues.add(Boolean.parseBoolean(value));
        }
        return booleanValues;
    }

    private List<String> getStringValues(String[] values) {
        return Arrays.asList(values);
    }

    private List getEnumValues(String[] values, JavaType javaType) throws BadRequestException {
        ArrayList<Object> enumValues = new ArrayList<Object>();
        for (String value : values) {
            try {
                enumValues.add(this.configuration.getObjectMapper().convertValue((Object)value, javaType));
            }
            catch (IllegalArgumentException e) {
                logger.error("Wrong value passed for enum : {}", (Object)e.getMessage());
                throw new BadRequestException("Wrong value passed for enum, javatype: " + javaType + " value: " + value);
            }
            catch (Exception e) {
                logger.error("Error in reading enum : {}", (Object)e.getMessage());
                throw new BadRequestException("Error in reading enum, javatype: " + javaType + " value: " + value);
            }
        }
        return enumValues;
    }
}

