/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.validator;

import com.flipkart.poseidon.api.APIManager;
import com.flipkart.poseidon.handlers.http.utils.StringUtils;
import com.flipkart.poseidon.helpers.ObjectMapperHelper;
import com.flipkart.poseidon.pojos.EndpointPOJO;
import com.flipkart.poseidon.validator.CustomValidator;
import com.flipkart.poseidon.validator.EndpointValidator;
import com.flipkart.poseidon.validator.ValidatorUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIValidator {
    private static final Logger logger = LoggerFactory.getLogger(APIValidator.class);
    private static final List<EndpointPOJO> pojos = new ArrayList<EndpointPOJO>();

    public static void main(String[] args) {
        Path dir = Paths.get(args[0], new String[0]);
        CustomValidator customValidator = null;
        if (args.length > 1 && !StringUtils.isNullOrEmpty((String)args[1])) {
            try {
                Class<?> customValidatorClass = Class.forName(args[1]);
                if (!CustomValidator.class.isAssignableFrom(customValidatorClass)) {
                    logger.error("Validator class passed does not implement CustomValidator");
                    System.exit(-1);
                } else {
                    customValidator = (CustomValidator)customValidatorClass.newInstance();
                }
            }
            catch (ClassNotFoundException e) {
                logger.error("Wrong CustomValidator passed", (Throwable)e);
                System.exit(-1);
            }
            catch (Exception e) {
                logger.error("Something went wrong while constructing CustomValidator", (Throwable)e);
                System.exit(-1);
            }
        }
        ArrayList<String> validConfigs = new ArrayList<String>();
        try {
            APIManager.scanAndAdd(dir, validConfigs);
            for (String config : validConfigs) {
                pojos.add((EndpointPOJO)ObjectMapperHelper.getMapper().readValue(config, EndpointPOJO.class));
            }
            HashMap<String, List<String>> errors = new HashMap<String, List<String>>();
            for (EndpointPOJO pojo : pojos) {
                List<String> pojoErrors = EndpointValidator.validate(pojo);
                if (customValidator != null) {
                    pojoErrors.addAll(customValidator.validate(pojo));
                }
                if (pojoErrors.isEmpty()) continue;
                errors.put(pojo.getHttpMethod() + " " + pojo.getUrl(), pojoErrors);
            }
            if (!errors.isEmpty()) {
                logger.error(ValidatorUtils.getFormattedErrorMessages(errors));
                System.exit(-1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

