/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.internal;

import com.flipkart.hydra.composer.Composer;
import com.flipkart.hydra.task.Task;
import com.flipkart.poseidon.datasources.AbstractNonBlockingDataSource;
import com.flipkart.poseidon.internal.APIComposer;
import com.flipkart.poseidon.internal.ByteArrayDataType;
import com.flipkart.poseidon.internal.ListDataType;
import com.flipkart.poseidon.internal.MapDataType;
import com.flipkart.poseidon.internal.NonBlockingDispatcher;
import com.flipkart.poseidon.mappers.Mapper;
import com.flipkart.poseidon.model.annotations.Trace;
import flipkart.lego.api.entities.DataType;
import flipkart.lego.api.entities.LegoSet;
import flipkart.lego.concurrency.api.Promise;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Trace(value=false)
public class NonBlockingOrchestratorDataSource
extends AbstractNonBlockingDataSource<Object, DataType> {
    private final Map<String, Object> initialParams;
    private final Map<String, Task> tasks;
    private final Object responseContext;
    private final Set<Mapper> mappers;
    private List<Object> mappedBeans;
    private APIComposer composer;
    private NonBlockingDispatcher dispatcher;
    private static final Logger logger = LoggerFactory.getLogger(NonBlockingOrchestratorDataSource.class);

    public NonBlockingOrchestratorDataSource(LegoSet legoSet, Map<String, Object> initialParams, Map<String, Task> tasks, Object responseContext, Set<Mapper> mappers, List<Object> mappedBeans) {
        super(legoSet, null);
        this.initialParams = initialParams;
        this.tasks = tasks;
        this.responseContext = responseContext;
        this.mappers = mappers;
        this.mappedBeans = mappedBeans;
        this.dispatcher = new NonBlockingDispatcher();
    }

    public Promise<Object> callAsync() throws Exception {
        logger.info("Thread executing callAsync - {}", (Object)Thread.currentThread().getName());
        this.composer = new APIComposer(this.responseContext, this.initialParams, this.mappers, this.mappedBeans);
        return this.dispatcher.execute(this.initialParams, this.tasks, (Composer)this.composer);
    }

    public DataType map(Object response) throws Exception {
        logger.info("Thread executing map - {}", (Object)Thread.currentThread().getName());
        response = this.dispatcher.map((Composer)this.composer);
        if (response == null) {
            return null;
        }
        if (response instanceof DataType) {
            return (DataType)response;
        }
        if (response instanceof Map) {
            return new MapDataType((Map)response);
        }
        if (response instanceof List) {
            return new ListDataType((Collection)((List)response));
        }
        if (response instanceof byte[]) {
            return new ByteArrayDataType((byte[])response);
        }
        throw new Exception("Unsupported response type");
    }
}

