/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.internal;

import com.flipkart.hydra.composer.Composer;
import com.flipkart.hydra.composer.DefaultComposer;
import com.flipkart.hydra.composer.exception.ComposerEvaluationException;
import com.flipkart.hydra.composer.exception.ComposerInstantiationException;
import com.flipkart.hydra.dispatcher.Dispatcher;
import com.flipkart.hydra.dispatcher.exception.DispatchFailedException;
import com.flipkart.hydra.task.Task;
import flipkart.lego.concurrency.api.CompositeFuture;
import flipkart.lego.concurrency.api.NonBlockingDataSource;
import flipkart.lego.concurrency.api.Promise;
import flipkart.lego.concurrency.promises.FutureWrapperPromise;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class NonBlockingDispatcher
implements Dispatcher {
    private final Map<String, Object> responses = new HashMap<String, Object>();
    private final Map<String, NonBlockingDataSource> datasources = new HashMap<String, NonBlockingDataSource>();
    private final Map<Future<Object>, String> futures = new HashMap<Future<Object>, String>();

    public Object execute(Map<String, Object> params, Map<String, Task> tasks, Object context) throws DispatchFailedException, ComposerEvaluationException {
        return this.execute(params, tasks, context, false);
    }

    public Object execute(Map<String, Object> params, Map<String, Task> tasks, Object context, boolean isAlreadyParsed) throws DispatchFailedException, ComposerEvaluationException {
        try {
            DefaultComposer defaultComposer = new DefaultComposer(context, isAlreadyParsed);
            return this.execute(params, tasks, (Composer)defaultComposer);
        }
        catch (ComposerInstantiationException e) {
            throw new DispatchFailedException("Unable to create composer.", (Throwable)e);
        }
    }

    public Promise<Object> execute(Map<String, Object> params, Map<String, Task> tasks, Composer composer) throws DispatchFailedException, ComposerEvaluationException {
        this.responses.putAll(params);
        for (String key : tasks.keySet()) {
            Task task = tasks.get(key);
            List dependencies = task.getDependencies();
            Map<String, Object> collectedDependencies = this.collectDependencies(dependencies);
            if (collectedDependencies.size() != dependencies.size()) continue;
            Future<Object> future = this.dispatchTask(key, task, collectedDependencies);
            this.futures.put(future, key);
        }
        if (this.futures.isEmpty()) {
            throw new DispatchFailedException("No possible resolution of dependencies found.");
        }
        Set<Future<Object>> futureCollection = this.futures.keySet();
        CompositeFuture compositeFuture = new CompositeFuture(futureCollection, true);
        return new FutureWrapperPromise((Future)compositeFuture);
    }

    public void shutdown() {
    }

    private Map<String, Object> collectDependencies(List<String> dependencies) {
        HashMap<String, Object> collectedDependencies = new HashMap<String, Object>();
        for (String dependency : dependencies) {
            if (!this.responses.containsKey(dependency)) continue;
            collectedDependencies.put(dependency, this.responses.get(dependency));
        }
        return collectedDependencies;
    }

    private Future<Object> dispatchTask(String key, Task task, Map<String, Object> responses) throws DispatchFailedException {
        try {
            Callable callable = task.getCallable(responses);
            if (!(callable instanceof NonBlockingDataSource)) {
                throw new UnsupportedOperationException("Async API should use only NonBlockingDataSource");
            }
            NonBlockingDataSource nbDataSource = (NonBlockingDataSource)callable;
            this.datasources.put(key, nbDataSource);
            return nbDataSource.call();
        }
        catch (Exception e) {
            throw new DispatchFailedException("Failed to dispatch task", (Throwable)e);
        }
    }

    public Object map(Composer composer) throws ComposerEvaluationException {
        this.futures.keySet().stream().forEach(future -> {
            try {
                String key = this.futures.get(future);
                NonBlockingDataSource nbDataSource = this.datasources.get(key);
                this.responses.put(key, nbDataSource.get());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        List dependencies = composer.getDependencies();
        Map<String, Object> collectedDependencies = this.collectDependencies(dependencies);
        return composer.compose(collectedDependencies);
    }
}

