/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.utils;

import com.fasterxml.jackson.databind.JavaType;
import com.flipkart.poseidon.handlers.http.utils.StringUtils;
import com.flipkart.poseidon.helpers.ObjectMapperHelper;
import com.flipkart.poseidon.model.VariableModel;
import com.flipkart.poseidon.pojos.ParamPOJO;

public class ApiHelper {
    public static String getUrlWithHttpMethod(String url, String httpMethod) {
        if (httpMethod == null) {
            return url;
        }
        return String.format("%s/%s", httpMethod, url).replaceAll("[/]{2,}", "/");
    }

    public static String getFormattedUrl(String url) {
        if (url.startsWith("/") && !url.endsWith("/")) {
            return url;
        }
        String partiallyFormattedUrl = String.format("/%s", url);
        if (!url.endsWith("/")) {
            return partiallyFormattedUrl;
        }
        partiallyFormattedUrl = partiallyFormattedUrl.replaceAll("[/]{2,}", "/");
        return partiallyFormattedUrl.substring(0, partiallyFormattedUrl.length() - 1);
    }

    public static JavaType constructJavaType(ParamPOJO param) {
        Object javaType = param.getType() != null ? ApiHelper.constructJavaType(param.getType()) : (!StringUtils.isNullOrEmpty((String)param.getJavatype()) ? ApiHelper.constructJavaType(param.getJavatype()) : null);
        return javaType;
    }

    private static JavaType constructJavaType(String type) {
        Class<?> clazz;
        try {
            clazz = Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Specify a known class " + type, e);
        }
        return ObjectMapperHelper.getMapper().getTypeFactory().constructType(clazz);
    }

    private static JavaType constructJavaType(VariableModel variableModel) {
        Class<?> clazz;
        try {
            clazz = Class.forName(variableModel.getType());
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Specify a known class " + variableModel.getType(), e);
        }
        JavaType[] javaTypes = new JavaType[variableModel.getTypes().length];
        for (int i = 0; i < variableModel.getTypes().length; ++i) {
            javaTypes[i] = ApiHelper.constructJavaType(variableModel.getTypes()[i]);
        }
        return ObjectMapperHelper.getMapper().getTypeFactory().constructParametrizedType(clazz, clazz, javaTypes);
    }
}

