/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.oas;

import com.fasterxml.jackson.databind.JavaType;
import com.flipkart.poseidon.api.APIManager;
import com.flipkart.poseidon.helper.ClassPathHelper;
import com.flipkart.poseidon.helpers.ObjectMapperHelper;
import com.flipkart.poseidon.legoset.PoseidonLegoSet;
import com.flipkart.poseidon.model.oas.Response;
import com.flipkart.poseidon.model.oas.Responses;
import com.flipkart.poseidon.pojos.EndpointPOJO;
import com.flipkart.poseidon.pojos.ParamPOJO;
import com.flipkart.poseidon.pojos.ParamsPOJO;
import com.flipkart.poseidon.pojos.TaskPOJO;
import com.flipkart.poseidon.utils.ApiHelper;
import com.flipkart.poseidon.validator.BlocksValidator;
import com.google.common.reflect.ClassPath;
import com.google.common.reflect.TypeToken;
import flipkart.lego.api.entities.DataSource;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;
import org.springframework.http.HttpMethod;

public class SchemaGenerator {
    private static final Map<String, JavaType> modelTypes = new HashMap<String, JavaType>();
    private static final Set<String> globalModelSet = new HashSet<String>();
    private static final Map<String, Class<? extends DataSource<?>>> datasources = new HashMap();
    private static final Set<String> noBuilderClasses = new HashSet<String>();
    private static final List<Class<? extends Annotation>> nonNullAnnotations = Arrays.asList(NotNull.class, Nonnull.class);
    private static final Consumer<Path> deleteIfExists = p -> {
        try {
            Files.deleteIfExists(p);
        }
        catch (Exception e) {
            System.out.println("Error while deleting model dir: " + e.getMessage());
        }
    };

    public static void main(String[] args) throws IOException, NoSuchMethodException {
        if (args.length < 3) {
            throw new UnsupportedOperationException("Correct Usage: <api-dir> <schema-target> <datasource-packages-csv>");
        }
        ArrayList<String> validConfigs = new ArrayList<String>();
        List<Object> pojos = new ArrayList<Object>();
        Path dir = Paths.get(args[0], new String[0]);
        Path genDir = Paths.get(args[1], new String[0]);
        Path apiDir = genDir.resolve("apis/v1");
        Path apiFile = apiDir.resolve("ServiceResource.json");
        Path modelsDir = genDir.resolve("models");
        if (Files.exists(modelsDir, new LinkOption[0])) {
            Files.walk(modelsDir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).peek(System.out::println).forEach(deleteIfExists);
        }
        if (args.length == 4) {
            noBuilderClasses.addAll(Arrays.asList(args[3].split(",")));
        }
        try {
            APIManager.scanAndAdd(dir, validConfigs);
            for (String config : validConfigs) {
                pojos.add(ObjectMapperHelper.getMapper().readValue(config, EndpointPOJO.class));
            }
            pojos = pojos.stream().sorted(Comparator.comparing(EndpointPOJO::getName)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Error while reading EndpointPOJO", e);
        }
        String[] datasourcePackages = args[2].split(",");
        BlocksValidator.main(datasourcePackages);
        SchemaGenerator.fetchDataSources(datasourcePackages);
        OpenAPI openAPI = new OpenAPI();
        Info info = new Info();
        info.title("ServiceResource");
        info.version("1.0");
        openAPI.info(info);
        LinkedHashMap<String, Map> paths = new LinkedHashMap<String, Map>();
        for (EndpointPOJO endpointPOJO : pojos) {
            Operation operation = new Operation();
            ParamsPOJO paramsPOJO = endpointPOJO.getParams();
            if (paramsPOJO != null) {
                if (paramsPOJO.getRequired() != null) {
                    for (ParamPOJO paramPOJO : paramsPOJO.getRequired()) {
                        if (paramPOJO.isFile()) continue;
                        if (paramPOJO.isBody()) {
                            RequestBody requestBody = new RequestBody();
                            requestBody.required(Boolean.valueOf(true));
                            Content content = new Content();
                            MediaType mediaType = new MediaType();
                            mediaType.schema(SchemaGenerator.createSchema(paramPOJO));
                            content.addMediaType("application/json", mediaType);
                            requestBody.content(content);
                            operation.requestBody(requestBody);
                            continue;
                        }
                        operation.addParametersItem(SchemaGenerator.createParameter(paramPOJO).required(Boolean.valueOf(true)));
                    }
                }
                if (paramsPOJO.getOptional() != null) {
                    for (ParamPOJO paramPOJO : paramsPOJO.getOptional()) {
                        if (paramPOJO.isFile() || paramPOJO.isBody()) continue;
                        operation.addParametersItem(SchemaGenerator.createParameter(paramPOJO));
                    }
                }
            }
            ApiResponses responses = new ApiResponses();
            if (endpointPOJO.getResponse() instanceof String) {
                String responseString = (String)endpointPOJO.getResponse();
                if ((responseString = responseString.substring(3, responseString.length() - 2)).startsWith("$")) {
                    responseString = responseString.substring(1);
                }
                TaskPOJO taskPOJO = endpointPOJO.getTasks().get(responseString);
                Class<DataSource<?>> dsClass = datasources.get(taskPOJO.getName());
                Type resolvedType = TypeToken.of(dsClass).resolveType(dsClass.getMethod("call", new Class[0]).getGenericReturnType()).getType();
                SchemaGenerator.resolveAPIResponse("200", resolvedType, responses, modelsDir);
                SchemaGenerator.handleOtherResponses(dsClass, responses, modelsDir);
            }
            operation.responses(responses);
            operation.operationId(endpointPOJO.getName());
            paths.computeIfAbsent(endpointPOJO.getUrl(), s -> new LinkedHashMap()).put(SchemaGenerator.getHttpMethod(endpointPOJO.getHttpMethod()), operation);
        }
        paths.forEach((k, v) -> {
            PathItem pathItem = new PathItem();
            pathItem.addExtension("x-old-path", k);
            v.forEach((arg_0, arg_1) -> ((PathItem)pathItem).operation(arg_0, arg_1));
            openAPI.path(k, pathItem);
        });
        byte[] apiBytes = Json.mapper().writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)openAPI);
        Files.createDirectories(apiFile.getParent(), new FileAttribute[0]);
        Files.write(apiFile, apiBytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        modelTypes.forEach((k, v) -> {
            try {
                Path modelFile = modelsDir.resolve(k + ".json");
                Files.createDirectories(modelFile.getParent(), new FileAttribute[0]);
                Files.write(modelFile, Json.mapper().writerWithDefaultPrettyPrinter().writeValueAsBytes(SchemaGenerator.generateSchema(v, modelsDir)), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while create model files", e);
            }
        });
    }

    private static void resolveAPIResponse(String status, Type resolvedType, ApiResponses responses, Path modelsDir) {
        Schema<?> responseSchema = SchemaGenerator.processType(resolvedType, modelsDir);
        ApiResponse response = new ApiResponse();
        Content content = new Content();
        MediaType mediaType = new MediaType();
        mediaType.schema(responseSchema);
        content.addMediaType("application/json", mediaType);
        response.content(content);
        response.description("Some random thing");
        responses.addApiResponse(status, response);
    }

    private static void handleOtherResponses(Class<? extends DataSource<?>> dsClass, ApiResponses responses, Path modelsDir) {
        Response[] responseArray;
        Responses responsesAnnotation = dsClass.getAnnotation(Responses.class);
        if (responsesAnnotation == null) {
            return;
        }
        for (Response response : responseArray = responsesAnnotation.value()) {
            SchemaGenerator.resolveAPIResponse(String.valueOf(response.status()), response.responseClass(), responses, modelsDir);
        }
    }

    private static Schema<?> generateSchema(JavaType javaType, Path modelsDir) {
        Class rawClass = javaType.getRawClass();
        return SchemaGenerator.processClass(rawClass, modelsDir);
    }

    private static Schema<?> processClass(Class<?> clazz, Path modelsDir) {
        Field[] declaredFields;
        Class<?> superclass;
        HashMap referencedClasses = new HashMap();
        int globalSetSize = globalModelSet.size();
        if (clazz.isEnum()) {
            Enum[] enumConstants = (Enum[])clazz.getEnumConstants();
            StringSchema schema = new StringSchema();
            Arrays.stream(enumConstants).forEach(e -> schema.addEnumItem(e.name()));
            return schema;
        }
        ComposedSchema schema = new ComposedSchema();
        schema.type("object");
        if (!noBuilderClasses.contains(clazz.getName())) {
            schema.addExtension("x-create-builder", (Object)true);
        }
        if ((superclass = clazz.getSuperclass()) != null && superclass != Object.class) {
            schema.allOf(Collections.singletonList(SchemaGenerator.createReference(superclass, null, referencedClasses)));
        }
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            schema.addProperties(field.getName(), SchemaGenerator.processField(clazz, field.getType(), field.getGenericType(), referencedClasses));
            if (!SchemaGenerator.isRequiredProperty(field)) continue;
            schema.addRequiredItem(field.getName());
        }
        if (globalSetSize < globalModelSet.size()) {
            referencedClasses.forEach((k, v) -> {
                try {
                    Path modelFile = modelsDir.resolve(k + ".json");
                    Files.createDirectories(modelFile.getParent(), new FileAttribute[0]);
                    Schema<?> referencedSchema = SchemaGenerator.processClass(v, modelsDir);
                    Files.write(modelFile, Json.mapper().writerWithDefaultPrettyPrinter().writeValueAsBytes(referencedSchema), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while create model files", e);
                }
            });
        }
        return schema;
    }

    private static boolean isRequiredProperty(Field field) {
        for (Class<? extends Annotation> nonNullAnnotation : nonNullAnnotations) {
            if (!field.isAnnotationPresent(nonNullAnnotation)) continue;
            return true;
        }
        return false;
    }

    private static Schema<?> processType(Type type, Path modelsDir) {
        HashMap referencedClasses = new HashMap();
        int globalSetSize = globalModelSet.size();
        Schema<?> schema = !(type instanceof ParameterizedType) ? (Map.class.isAssignableFrom((Class)type) || List.class.isAssignableFrom((Class)type) ? SchemaGenerator.processType(type, null, referencedClasses) : SchemaGenerator.createReference((Class)type, null, referencedClasses)) : SchemaGenerator.processType(type, null, referencedClasses);
        if (globalSetSize < globalModelSet.size()) {
            referencedClasses.forEach((k, v) -> {
                try {
                    Path modelFile = modelsDir.resolve(k + ".json");
                    Files.createDirectories(modelFile.getParent(), new FileAttribute[0]);
                    Schema<?> referencedSchema = SchemaGenerator.processClass(v, modelsDir);
                    Files.write(modelFile, Json.mapper().writerWithDefaultPrettyPrinter().writeValueAsBytes(referencedSchema), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while create model files", e);
                }
            });
        }
        return schema;
    }

    private static Schema<?> processField(Class<?> baseClass, Class<?> clazz, Type type, Map<String, Class<?>> referencedClasses) {
        if (clazz == Integer.class) {
            return new IntegerSchema();
        }
        if (clazz == Integer.TYPE) {
            return new IntegerSchema().extensions(Collections.singletonMap("x-primitive", true));
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return new IntegerSchema().format("int64");
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return new NumberSchema();
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return new NumberSchema().format("num64");
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return new BooleanSchema();
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return new StringSchema().format("byte");
        }
        if (clazz == String.class) {
            return new StringSchema();
        }
        if (Map.class.isAssignableFrom(clazz) || List.class.isAssignableFrom(clazz)) {
            return SchemaGenerator.processType(type, baseClass, referencedClasses);
        }
        if (clazz == Object.class) {
            return new ObjectSchema().extensions(Collections.singletonMap("x-no-contract", true));
        }
        if (clazz.isEnum()) {
            return SchemaGenerator.createReference(clazz, baseClass, referencedClasses);
        }
        if (clazz.isArray()) {
            return new ArraySchema().items(SchemaGenerator.processField(baseClass, clazz.getComponentType(), clazz.getComponentType(), referencedClasses));
        }
        return SchemaGenerator.createReference(clazz, baseClass, referencedClasses);
    }

    private static Schema<?> createReference(Class<?> clazz, Class<?> baseClass, Map<String, Class<?>> referencedClasses) {
        referencedClasses.put(clazz.getName().replace('.', '/'), clazz);
        globalModelSet.add(clazz.getName());
        return new Schema().$ref(baseClass != null ? SchemaGenerator.resolveModelContextPath(clazz.getName(), baseClass) : SchemaGenerator.resolvePath(clazz.getName()));
    }

    private static Schema<?> processType(Type type, Class<?> baseClass, Map<String, Class<?>> referencedClasses) {
        if (type instanceof ParameterizedType) {
            Class rawType = (Class)((ParameterizedType)type).getRawType();
            if (Map.class.isAssignableFrom(rawType)) {
                return new ObjectSchema().additionalProperties(SchemaGenerator.processType(((ParameterizedType)type).getActualTypeArguments()[1], baseClass, referencedClasses));
            }
            if (List.class.isAssignableFrom(rawType)) {
                return new ArraySchema().items(SchemaGenerator.processType(((ParameterizedType)type).getActualTypeArguments()[0], baseClass, referencedClasses));
            }
            return SchemaGenerator.processField(baseClass, rawType, type, referencedClasses);
        }
        Class clazz = (Class)type;
        if (Map.class.isAssignableFrom(clazz)) {
            return new ObjectSchema().additionalProperties(SchemaGenerator.processType(Object.class, baseClass, referencedClasses));
        }
        if (List.class.isAssignableFrom(clazz)) {
            return new ArraySchema().items(SchemaGenerator.processType(Object.class, baseClass, referencedClasses));
        }
        return SchemaGenerator.processField(baseClass, clazz, type, referencedClasses);
    }

    private static Parameter createParameter(ParamPOJO paramPOJO) {
        Parameter parameter = new Parameter();
        if (paramPOJO.getInternalName() != null) {
            parameter.addExtension("x-internal-name", (Object)paramPOJO.getInternalName());
        }
        parameter.name(paramPOJO.getName()).in(SchemaGenerator.getParamType(paramPOJO)).schema(SchemaGenerator.createSchema(paramPOJO));
        return parameter;
    }

    private static String getParamType(ParamPOJO paramPOJO) {
        if (paramPOJO.isPathparam()) {
            return "path";
        }
        if (paramPOJO.isHeader()) {
            return "header";
        }
        return "query";
    }

    private static Schema<?> createSchema(ParamPOJO paramPOJO) {
        StringSchema schema;
        if (paramPOJO.getDatatype() == null) {
            return SchemaGenerator.createSchemaPOJO(paramPOJO);
        }
        switch (paramPOJO.getDatatype()) {
            case STRING: {
                schema = new StringSchema();
                break;
            }
            case BOOLEAN: {
                schema = new BooleanSchema();
                break;
            }
            case INTEGER: {
                schema = new IntegerSchema();
                break;
            }
            case LONG: {
                schema = new IntegerSchema();
                schema.format("int64");
                break;
            }
            case NUMBER: {
                schema = new NumberSchema();
                break;
            }
            case ENUM: {
                schema = SchemaGenerator.createSchemaPOJO(paramPOJO);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return schema;
    }

    private static Schema<?> createSchemaPOJO(ParamPOJO paramPOJO) {
        JavaType javaType = ApiHelper.constructJavaType(paramPOJO);
        String ref = SchemaGenerator.resolvePath(javaType.getRawClass().getName());
        modelTypes.put(javaType.getRawClass().getName().replace('.', '/'), javaType);
        globalModelSet.add(javaType.getRawClass().getName());
        Schema schema = new Schema();
        schema.$ref(ref);
        return schema;
    }

    private static String resolvePath(String path) {
        String resolvedPath = path.replace('.', '/');
        resolvedPath = "../../models/" + resolvedPath;
        return resolvedPath + ".json";
    }

    private static String resolveModelContextPath(String path, Class<?> baseClass) {
        String baseClassPath = baseClass.getName();
        int minLength = baseClassPath.length() < path.length() ? baseClassPath.length() : path.length();
        int cutOff = 0;
        for (int i = 0; i < minLength; ++i) {
            if (baseClassPath.charAt(i) == path.charAt(i)) continue;
            cutOff = i;
        }
        String processedPath = path.substring(cutOff);
        int parts = baseClass.getName().split("\\.").length - 1;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < parts; ++i) {
            builder.append("../");
        }
        builder.append(path.replace('.', '/'));
        builder.append(".json");
        return builder.toString();
    }

    private static PathItem.HttpMethod getHttpMethod(HttpMethod httpMethod) {
        switch (httpMethod) {
            case GET: {
                return PathItem.HttpMethod.GET;
            }
            case POST: {
                return PathItem.HttpMethod.POST;
            }
            case PUT: {
                return PathItem.HttpMethod.PUT;
            }
            case DELETE: {
                return PathItem.HttpMethod.DELETE;
            }
            case PATCH: {
                return PathItem.HttpMethod.PATCH;
            }
            case HEAD: {
                return PathItem.HttpMethod.HEAD;
            }
            case OPTIONS: {
                return PathItem.HttpMethod.OPTIONS;
            }
            case TRACE: {
                return PathItem.HttpMethod.TRACE;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static void fetchDataSources(String[] args) {
        try {
            Set classInfos = ClassPathHelper.getPackageClasses((ClassLoader)Thread.currentThread().getContextClassLoader(), Arrays.asList(args));
            System.out.println("Classes in ClassLoader: " + classInfos.size());
            for (ClassPath.ClassInfo classInfo : classInfos) {
                Class<?> clazz = Class.forName(classInfo.getName());
                if (Modifier.isAbstract(clazz.getModifiers()) || !DataSource.class.isAssignableFrom(clazz)) continue;
                datasources.put((String)PoseidonLegoSet.getBlockId(clazz).get(), (Class<DataSource<?>>)clazz);
            }
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

