/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.validator;

import com.flipkart.poseidon.api.APIManager;
import com.flipkart.poseidon.handlers.http.utils.StringUtils;
import com.flipkart.poseidon.helper.ClassPathHelper;
import com.flipkart.poseidon.helpers.ObjectMapperHelper;
import com.flipkart.poseidon.legoset.PoseidonLegoSet;
import com.flipkart.poseidon.pojos.EndpointPOJO;
import com.flipkart.poseidon.validator.CustomValidator;
import com.flipkart.poseidon.validator.EndpointValidator;
import com.flipkart.poseidon.validator.ValidatorUtils;
import com.google.common.reflect.ClassPath;
import flipkart.lego.api.entities.DataSource;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIValidator {
    private static final Logger logger = LoggerFactory.getLogger(APIValidator.class);
    private static final List<EndpointPOJO> pojos = new ArrayList<EndpointPOJO>();

    public static void main(String[] args) {
        Path dir = Paths.get(args[0], new String[0]);
        CustomValidator customValidator = null;
        boolean validateDataSources = false;
        List<Object> packagesToScan = new ArrayList();
        if (args.length > 1) {
            if (!StringUtils.isNullOrEmpty((String)args[1].trim())) {
                try {
                    Class<?> customValidatorClass = Class.forName(args[1]);
                    if (!CustomValidator.class.isAssignableFrom(customValidatorClass)) {
                        logger.error("Validator class passed does not implement CustomValidator");
                        System.exit(-1);
                    } else {
                        customValidator = (CustomValidator)customValidatorClass.newInstance();
                    }
                }
                catch (ClassNotFoundException e) {
                    logger.error("Wrong CustomValidator passed", (Throwable)e);
                    System.exit(-1);
                }
                catch (Exception e) {
                    logger.error("Something went wrong while constructing CustomValidator", (Throwable)e);
                    System.exit(-1);
                }
            }
            if (args.length > 2) {
                validateDataSources = true;
                String[] datasourcePackages = args[2].split(",");
                packagesToScan = Arrays.asList(datasourcePackages);
            }
        }
        ArrayList<String> validConfigs = new ArrayList<String>();
        try {
            APIManager.scanAndAdd(dir, validConfigs);
            for (String config : validConfigs) {
                pojos.add((EndpointPOJO)ObjectMapperHelper.getMapper().readValue(config, EndpointPOJO.class));
            }
            Set classInfos = ClassPathHelper.getPackageClasses((ClassLoader)Thread.currentThread().getContextClassLoader(), packagesToScan);
            HashMap datasources = new HashMap();
            for (ClassPath.ClassInfo classInfo : classInfos) {
                Class<?> clazz = Class.forName(classInfo.getName());
                if (Modifier.isAbstract(clazz.getModifiers()) || !DataSource.class.isAssignableFrom(clazz)) continue;
                datasources.put((String)PoseidonLegoSet.getBlockId(clazz).get(), (Class<DataSource<?>>)clazz);
            }
            HashMap<String, List<String>> errors = new HashMap<String, List<String>>();
            for (EndpointPOJO pojo : pojos) {
                List<String> pojoErrors = EndpointValidator.validate(pojo, datasources, validateDataSources);
                if (customValidator != null) {
                    pojoErrors.addAll(customValidator.validate(pojo));
                }
                if (pojoErrors.isEmpty()) continue;
                errors.put(pojo.getHttpMethod() + " " + pojo.getUrl(), pojoErrors);
            }
            if (!errors.isEmpty()) {
                logger.error(ValidatorUtils.getFormattedErrorMessages(errors));
                System.exit(-1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

