/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.cadfael;

import com.flipkart.poseidon.cadfael.artifact.NonVersionedArtifact;
import com.flipkart.poseidon.cadfael.artifact.Scope;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;

public class Cadfael {
    private final List<RemoteRepository> repositories;
    private final RepositorySystem system;
    private final RepositorySystemSession session;
    private final Set<NonVersionedArtifact> allowedArtifacts;
    private final Set<Scope> ignoredScopes;
    private final boolean rejectSnapshots;

    private Cadfael(List<RemoteRepository> repositories, Set<NonVersionedArtifact> allowedArtifacts, Set<Scope> ignoredScopes, boolean rejectSnapshots) {
        this.repositories = repositories;
        this.allowedArtifacts = allowedArtifacts;
        this.ignoredScopes = ignoredScopes;
        this.rejectSnapshots = rejectSnapshots;
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        this.system = this.newRepositorySystem(locator);
        this.session = this.newSession(this.system);
    }

    public Set<Dependency> getAllDependencies(Artifact artifact) throws ArtifactDescriptorException {
        ArtifactDescriptorRequest request = new ArtifactDescriptorRequest(artifact, this.repositories, null);
        ArtifactDescriptorResult result = this.system.readArtifactDescriptor(this.session, request);
        HashSet<Dependency> dependencies = new HashSet<Dependency>(result.getManagedDependencies());
        dependencies.addAll(result.getDependencies());
        return dependencies;
    }

    public Set<Artifact> getRejectedDependencies(Artifact artifact) throws ArtifactDescriptorException {
        Set<Dependency> allDependencies = this.getAllDependencies(artifact);
        HashSet<Artifact> rejected = new HashSet<Artifact>();
        for (Dependency dependency : allDependencies) {
            Scope scope = Scope.compile;
            try {
                scope = Scope.valueOf(dependency.getScope().toLowerCase());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.ignoredScopes.contains((Object)scope) || (!dependency.getArtifact().isSnapshot() || !this.rejectSnapshots) && !this.notAllowed(this.allowedArtifacts, dependency)) continue;
            rejected.add(dependency.getArtifact());
        }
        return rejected;
    }

    private boolean matches(Dependency dependency, NonVersionedArtifact artifact) {
        return dependency.getArtifact().getGroupId().equals(artifact.getGroupId()) && dependency.getArtifact().getArtifactId().equals(artifact.getArtifactId());
    }

    private boolean notAllowed(Set<NonVersionedArtifact> artifacts, Dependency dependency) {
        for (NonVersionedArtifact artifact : artifacts) {
            if (!this.matches(dependency, artifact)) continue;
            return false;
        }
        return true;
    }

    private RepositorySystem newRepositorySystem(DefaultServiceLocator locator) {
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private RepositorySystemSession newSession(RepositorySystem system) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository("target/local-repo");
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        return session;
    }

    public static Builder builder(RemoteRepository repository) {
        return new Builder(repository);
    }

    public static Builder builder(Set<RemoteRepository> repositories) {
        return new Builder(repositories);
    }

    public static class Builder {
        private final Set<RemoteRepository> repositories = new HashSet<RemoteRepository>();
        private Set<NonVersionedArtifact> allowedArtifacts = new HashSet<NonVersionedArtifact>();
        private final Set<Scope> ignoredScopes = new HashSet<Scope>();
        private boolean rejectSnapshots = false;

        private Builder(RemoteRepository repository) {
            this.repositories.add(repository);
        }

        private Builder(Set<RemoteRepository> repositories) {
            this.repositories.addAll(repositories);
        }

        public Builder addRepository(RemoteRepository repository) {
            if (repository != null) {
                this.repositories.add(repository);
            }
            return this;
        }

        public Builder allowedArtifacts(Set<NonVersionedArtifact> artifacts) {
            this.allowedArtifacts = artifacts == null ? new HashSet() : artifacts;
            return this;
        }

        public Builder rejectSnapshots() {
            this.rejectSnapshots = true;
            return this;
        }

        public Builder ignoreProvidedScope() {
            this.ignoredScopes.add(Scope.provided);
            return this;
        }

        public Builder ignoreTestScope() {
            this.ignoredScopes.add(Scope.test);
            return this;
        }

        public Cadfael build() {
            return new Cadfael(new ArrayList<RemoteRepository>(this.repositories), this.allowedArtifacts, this.ignoredScopes, this.rejectSnapshots);
        }
    }
}

