/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon;

import ch.qos.logback.access.jetty.RequestLogImpl;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.JvmAttributeGaugeSet;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.jetty9.InstrumentedHandler;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.codahale.metrics.servlets.AdminServlet;
import com.codahale.metrics.servlets.HealthCheckServlet;
import com.codahale.metrics.servlets.MetricsServlet;
import com.fasterxml.jackson.databind.JavaType;
import com.flipkart.phantom.runtime.impl.jetty.filter.ServletTraceFilter;
import com.flipkart.poseidon.api.Application;
import com.flipkart.poseidon.api.Configuration;
import com.flipkart.poseidon.core.PoseidonServlet;
import com.flipkart.poseidon.core.RewriteRule;
import com.flipkart.poseidon.filters.HystrixContextFilter;
import com.flipkart.poseidon.healthchecks.Rotation;
import com.flipkart.poseidon.helpers.ObjectMapperHelper;
import com.flipkart.poseidon.metrics.Metrics;
import com.flipkart.poseidon.tracing.ServletTraceFilterBuilder;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.RewriteRegexRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.GzipFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.trpr.platform.runtime.impl.bootstrap.spring.Bootstrap;

@Service
public class Poseidon {
    private static final Logger logger = LoggerFactory.getLogger(Poseidon.class);
    private final Configuration configuration;
    private final Application application;

    @Autowired
    public Poseidon(Configuration configuration, Application application) {
        this.configuration = configuration;
        this.application = application;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            throw new RuntimeException("No Bootstrap File Specified");
        }
        new Bootstrap().init(args[0]);
    }

    public void run() {
        try {
            Server server = new Server(this.configuration.getPort());
            if (!this.configuration.sendServerVersion()) {
                this.disableSendingServerVersion(server);
            }
            server.setHandler((Handler)this.getHandlers());
            Poseidon.initializeMetricReporters();
            server.start();
        }
        catch (Exception e) {
            logger.error("Unable to start server.", (Throwable)e);
        }
    }

    private HandlerCollection getHandlers() {
        ContextHandlerCollection contextHandlerCollection = new ContextHandlerCollection();
        contextHandlerCollection.setHandlers(new Handler[]{this.getRequestLogHandler(this.getRewriteHandler(this.getPoseidonHandler())), this.getMetricsHandler()});
        return contextHandlerCollection;
    }

    private Handler getRequestLogHandler(Handler handler) {
        RequestLogImpl requestLog = new RequestLogImpl();
        requestLog.setFileName(this.configuration.getLogbackAccessPath());
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        requestLogHandler.setHandler(handler);
        return requestLogHandler;
    }

    private Handler getRewriteHandler(Handler handler) {
        RewriteHandler rewriteHandler = new RewriteHandler();
        rewriteHandler.setRewritePathInfo(false);
        rewriteHandler.setRewriteRequestURI(true);
        rewriteHandler.setOriginalPathAttribute("__path");
        rewriteHandler.setHandler(handler);
        try {
            JavaType listRuleType = ObjectMapperHelper.getMapper().getTypeFactory().constructParametricType(List.class, new Class[]{RewriteRule.class});
            List rules = (List)ObjectMapperHelper.getMapper().readValue((InputStream)new FileInputStream(this.configuration.getRewriteFilePath()), listRuleType);
            for (RewriteRule rule : rules) {
                if (!rule.isActive()) continue;
                RewriteRegexRule regexRule = new RewriteRegexRule();
                regexRule.setRegex(rule.getFrom());
                regexRule.setReplacement(rule.getTo());
                rewriteHandler.addRule((Rule)regexRule);
            }
        }
        catch (IOException e) {
            logger.error("Unable to read Rewrite Rules", (Throwable)e);
        }
        return rewriteHandler;
    }

    private Handler getPoseidonHandler() {
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        servletContextHandler.setContextPath("/");
        servletContextHandler.addServlet(new ServletHolder((Servlet)this.getPoseidonServlet()), "/*");
        this.addFilters(servletContextHandler);
        InstrumentedHandler instrumentedHandler = new InstrumentedHandler(Metrics.getRegistry());
        instrumentedHandler.setHandler((Handler)servletContextHandler);
        return instrumentedHandler;
    }

    private ServletContextHandler getMetricsHandler() {
        MetricRegistry registry = Metrics.getRegistry();
        HealthCheckRegistry healthCheckRegistry = Metrics.getHealthCheckRegistry();
        healthCheckRegistry.register("rotation", (HealthCheck)new Rotation(this.configuration.getRotationStatusFilePath()));
        registry.registerAll((MetricSet)new GarbageCollectorMetricSet());
        registry.registerAll((MetricSet)new MemoryUsageGaugeSet());
        registry.registerAll((MetricSet)new ThreadStatesGaugeSet());
        registry.registerAll((MetricSet)new JvmAttributeGaugeSet());
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        servletContextHandler.setContextPath("/__metrics");
        servletContextHandler.setAttribute(MetricsServlet.class.getCanonicalName() + ".registry", (Object)registry);
        servletContextHandler.setAttribute(HealthCheckServlet.class.getCanonicalName() + ".registry", (Object)healthCheckRegistry);
        servletContextHandler.addServlet(new ServletHolder((Servlet)new AdminServlet()), "/*");
        return servletContextHandler;
    }

    private static void initializeMetricReporters() {
        JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)Metrics.getRegistry()).build();
        jmxReporter.start();
    }

    private void addFilters(ServletContextHandler servletContextHandler) {
        ServletTraceFilter servletTraceFilter = ServletTraceFilterBuilder.build(this.configuration);
        if (servletTraceFilter != null) {
            servletContextHandler.addFilter(new FilterHolder((Filter)servletTraceFilter), "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        servletContextHandler.addFilter(new FilterHolder((Filter)new HystrixContextFilter()), "/*", EnumSet.of(DispatcherType.REQUEST));
        servletContextHandler.addFilter(new FilterHolder((Filter)new GzipFilter()), "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private PoseidonServlet getPoseidonServlet() {
        return new PoseidonServlet(this.application, this.getDataSourceExecutor(), this.getFilterExecutor());
    }

    private ExecutorService getDataSourceExecutor() {
        return Executors.newCachedThreadPool();
    }

    private ExecutorService getFilterExecutor() {
        return Executors.newCachedThreadPool();
    }

    private void disableSendingServerVersion(Server server) {
        for (Connector connector : server.getConnectors()) {
            for (ConnectionFactory connectionFactory : connector.getConnectionFactories()) {
                if (!(connectionFactory instanceof HttpConnectionFactory)) continue;
                ((HttpConnectionFactory)connectionFactory).getHttpConfiguration().setSendServerVersion(false);
            }
        }
    }
}

