/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.core;

import com.flipkart.poseidon.api.Application;
import com.flipkart.poseidon.api.Configuration;
import com.flipkart.poseidon.api.HeaderConfiguration;
import com.flipkart.poseidon.core.PoseidonRequest;
import com.flipkart.poseidon.core.PoseidonResponse;
import com.flipkart.poseidon.core.RequestContext;
import com.flipkart.poseidon.exception.DataSourceException;
import com.flipkart.poseidon.helpers.ObjectMapperHelper;
import com.flipkart.poseidon.serviceclients.ServiceContext;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import flipkart.lego.api.exceptions.BadRequestException;
import flipkart.lego.api.exceptions.ElementNotFoundException;
import flipkart.lego.api.exceptions.InternalErrorException;
import flipkart.lego.api.exceptions.ProcessingException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class PoseidonServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(PoseidonServlet.class);
    private final Application application;
    private final ExecutorService datasourceTPE;
    private final ExecutorService filterTPE;
    private final Configuration configuration;

    public PoseidonServlet(Application application, Configuration configuration, ExecutorService datasourceTPE, ExecutorService filterTPE) {
        this.application = application;
        this.configuration = configuration;
        this.datasourceTPE = datasourceTPE;
        this.filterTPE = filterTPE;
        application.init(datasourceTPE, filterTPE);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(HttpMethod.GET, request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(HttpMethod.POST, request, response);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(HttpMethod.HEAD, request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(HttpMethod.PUT, request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(HttpMethod.DELETE, request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(HttpMethod.OPTIONS, request, response);
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(HttpMethod.TRACE, request, response);
    }

    protected void doRequest(HttpMethod method, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        this.setRequestContext(httpRequest);
        this.setServiceContext(httpRequest);
        PoseidonRequest request = new PoseidonRequest(httpRequest);
        request.setAttribute("poseidon.method", (Object)method);
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)httpRequest)) {
            this.handleFileUpload(request, httpRequest);
        } else {
            StringBuffer requestBuffer = new StringBuffer();
            String line = null;
            try {
                BufferedReader reader = httpRequest.getReader();
                while ((line = reader.readLine()) != null) {
                    requestBuffer.append(line);
                }
            }
            catch (Exception e) {
                logger.warn("301: Couldn't read body" + e.getMessage());
            }
            request.setAttribute("body", (Object)requestBuffer.toString());
        }
        PoseidonResponse response = new PoseidonResponse();
        response.setContentType(this.application.getDefaultMediaType());
        try {
            this.buildResponse(request, response, httpResponse);
        }
        catch (ProcessingException exception) {
            logger.warn("301: " + exception.getMessage());
            this.redirect(response, httpResponse);
        }
        catch (BadRequestException exception) {
            logger.error("400: {}", (Throwable)exception);
            this.badRequest(response, httpResponse, (Exception)((Object)exception));
        }
        catch (ElementNotFoundException exception) {
            logger.error("404: {}", (Throwable)exception);
            this.elementNotFound(response, httpResponse, (Exception)((Object)exception));
        }
        catch (Throwable exception) {
            logger.error("500: {}", exception);
            this.internalError(response, httpResponse, exception);
        }
    }

    private void setRequestContext(HttpServletRequest httpServletRequest) {
        RequestContext.set((String)"poseidon.method", (Object)httpServletRequest.getMethod());
        RequestContext.set((String)"sourceAddress", (Object)httpServletRequest.getRemoteAddr());
    }

    private void setServiceContext(HttpServletRequest httpServletRequest) {
        if (this.configuration.getHeadersConfiguration() == null || this.configuration.getHeadersConfiguration().getGlobalHeaders() == null) {
            return;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (HeaderConfiguration headerConfiguration : this.configuration.getHeadersConfiguration().getGlobalHeaders()) {
            String value = httpServletRequest.getHeader(headerConfiguration.getName());
            if (value == null) {
                value = headerConfiguration.getDefaultValue();
            }
            if (value == null) continue;
            headers.put(headerConfiguration.getName(), value);
        }
        ImmutableMap immutableHeaders = ImmutableMap.copyOf(headers);
        ServiceContext.set((String)"headers", (Object)immutableHeaders);
        RequestContext.set((String)"poseidon.headers", (Object)immutableHeaders);
    }

    private void handleFileUpload(PoseidonRequest request, HttpServletRequest httpRequest) throws IOException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        File repository = new File("/tmp");
        if (repository.exists()) {
            factory.setRepository(repository);
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        List fileItems = null;
        try {
            fileItems = upload.parseRequest(httpRequest);
        }
        catch (FileUploadException e) {
            throw new IOException(e);
        }
        for (FileItem fileItem : fileItems) {
            String name = fileItem.getFieldName();
            if (fileItem.isFormField()) {
                request.setAttribute(name, (Object)new String[]{fileItem.getString()});
                continue;
            }
            request.setAttribute(name, (Object)fileItem);
        }
    }

    private void buildResponse(PoseidonRequest request, PoseidonResponse poseidonResponse, HttpServletResponse httpResponse) throws BadRequestException, ElementNotFoundException, InternalErrorException, ProcessingException, IOException {
        this.application.handleRequest(request, poseidonResponse);
        this.setHeaders(poseidonResponse, httpResponse);
        this.setCookies(poseidonResponse, httpResponse);
        httpResponse.setContentType(poseidonResponse.getContentType().toString());
        int statusCode = poseidonResponse.getStatusCode();
        if (statusCode < 100) {
            statusCode = 200;
        }
        httpResponse.setStatus(statusCode);
        Object responseObj = poseidonResponse.getResponse();
        if (responseObj != null) {
            String responseStr = "";
            responseStr = responseObj instanceof String ? (String)responseObj : ObjectMapperHelper.getMapper().writeValueAsString(responseObj);
            httpResponse.getWriter().println(responseStr);
        }
    }

    private void redirect(PoseidonResponse response, HttpServletResponse httpResponse) {
        this.setHeaders(response, httpResponse);
        this.setCookies(response, httpResponse);
        httpResponse.setStatus(301);
        httpResponse.setHeader("Location", response.getAttribute("poseidon.redirectURL"));
    }

    private void setHeaders(PoseidonResponse response, HttpServletResponse httpResponse) {
        ConcurrentHashMap headers = response.getHeaders();
        for (String key : headers.keySet()) {
            httpResponse.setHeader(key, (String)headers.get(key));
        }
    }

    private void setCookies(PoseidonResponse response, HttpServletResponse httpResponse) {
        ConcurrentHashMap cookies = response.getCookies();
        for (Cookie cookie : cookies.values()) {
            httpResponse.addCookie(cookie);
        }
    }

    private void badRequest(PoseidonResponse response, HttpServletResponse httpServletResponse, Exception exception) throws IOException {
        this.processErrorResponse(400, response, httpServletResponse, exception);
    }

    private void elementNotFound(PoseidonResponse response, HttpServletResponse httpResponse, Exception exception) throws IOException {
        this.processErrorResponse(404, response, httpResponse, exception);
    }

    private void internalError(PoseidonResponse response, HttpServletResponse httpResponse, Throwable throwable) throws IOException {
        this.processErrorResponse(500, response, httpResponse, throwable);
    }

    private void processErrorResponse(int statusCode, PoseidonResponse response, HttpServletResponse httpResponse, Throwable throwable) throws IOException {
        this.setHeaders(response, httpResponse);
        this.setCookies(response, httpResponse);
        Throwable generatedException = Optional.ofNullable(ExceptionUtils.getRootCause((Throwable)throwable)).orElse(throwable);
        if (this.configuration.getExceptionMapper() == null || !this.configuration.getExceptionMapper().map(generatedException, httpResponse)) {
            MediaType contentType = this.application.getDefaultMediaType();
            String errorMsg = "";
            if (generatedException != null && generatedException instanceof DataSourceException) {
                DataSourceException dsException = (DataSourceException)generatedException;
                if (dsException.getResponse() != null) {
                    errorMsg = ObjectMapperHelper.getMapper().writeValueAsString(dsException.getResponse());
                }
                if (dsException.getStatusCode() > 0) {
                    statusCode = dsException.getStatusCode();
                }
            } else {
                errorMsg = throwable.getMessage();
            }
            httpResponse.setContentType(contentType.toString());
            httpResponse.setStatus(statusCode);
            httpResponse.getWriter().println(errorMsg);
        }
    }
}

