/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.api;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;

public class JettyFilterConfiguration {
    private Filter filter;
    private List<String> mappings;
    private Map<String, String> initParameters = new HashMap<String, String>();
    private EnumSet<DispatcherType> dispatcherTypes;

    public JettyFilterConfiguration(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter configurations cannot be empty");
        }
        this.filter = filter;
        this.mappings = Collections.singletonList("/*");
        this.dispatcherTypes = EnumSet.of(DispatcherType.REQUEST);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public List<String> getMappings() {
        return this.mappings;
    }

    public Map<String, String> getInitParameters() {
        return this.initParameters;
    }

    public EnumSet<DispatcherType> getDispatcherTypes() {
        return this.dispatcherTypes;
    }

    public void setMappings(List<String> mappings) {
        if (mappings == null) {
            throw new IllegalArgumentException("Filter configurations cannot be empty");
        }
        this.mappings = mappings;
    }

    public void setDispatcherTypes(EnumSet<DispatcherType> dispatcherTypes) {
        if (dispatcherTypes == null) {
            throw new IllegalArgumentException("Filter configurations cannot be empty");
        }
        this.dispatcherTypes = dispatcherTypes;
    }

    public void setInitParameters(Map<String, String> initParameters) {
        if (initParameters == null) {
            throw new IllegalArgumentException("Filter configurations cannot be empty");
        }
        this.initParameters = initParameters;
    }
}

