/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon;

import com.flipkart.poseidon.Poseidon;
import com.flipkart.poseidon.PoseidonContext;
import com.flipkart.poseidon.metrics.Metrics;
import com.netflix.hystrix.contrib.codahalemetricspublisher.HystrixCodaHaleMetricsPublisher;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;
import org.trpr.platform.core.impl.event.PlatformApplicationEvent;
import org.trpr.platform.core.spi.event.PlatformEventConsumer;
import org.trpr.platform.model.event.PlatformEvent;
import org.trpr.platform.runtime.impl.event.BootstrapProgressMonitor;

@Component
public class BootstrapListener
implements PlatformEventConsumer {
    private static final Logger logger = LoggerFactory.getLogger((String)"PoseidonStartupLogger");

    public void setBootstrapProgressMonitor(BootstrapProgressMonitor bootstrapProgressMonitor) {
        bootstrapProgressMonitor.addBootstrapEventListener((PlatformEventConsumer)this);
    }

    public void onApplicationEvent(PlatformApplicationEvent event) {
        PlatformEvent platformEvent;
        if (event.getSource() instanceof PlatformEvent && "BootstrapMonitoredEvent".equals((platformEvent = (PlatformEvent)event.getSource()).getEventType())) {
            if ("started".equals(platformEvent.getEventStatus())) {
                this.registerHystrixPlugins();
                logger.info("\n************************************\n______ \n| ___ \\\n| |_/ /\n|  __/ \n| |    Handlers Initialized.\n\\_|    Now starting Poseidon...\n************************************");
                this.startPoseidon();
            } else if ("stopped".equals(platformEvent.getEventStatus())) {
                this.stopPoseidon();
            }
        }
    }

    private void registerHystrixPlugins() {
        logger.info("Registering hystrix jmx metrics plugin");
        HystrixCodaHaleMetricsPublisher publisher = new HystrixCodaHaleMetricsPublisher(Metrics.getRegistry());
        HystrixPlugins.getInstance().registerMetricsPublisher((HystrixMetricsPublisher)publisher);
        logger.info("Registered hystrix jmx metrics plugin");
    }

    private void startPoseidon() {
        new ClassPathXmlApplicationContext("web.xml");
        PoseidonContext.getBean(Poseidon.class).start();
    }

    private void stopPoseidon() {
        PoseidonContext.getBean(Poseidon.class).stop();
    }
}

