/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.filters;

import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;

public class RequestGzipFilter
implements Filter {
    private static final String _PATCH = "PATCH";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean requestTypeSupported;
        Object servletRequest = (HttpServletRequest)request;
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        boolean isGzipped = servletRequest.getHeader("Content-Encoding") != null && servletRequest.getHeader("Content-Encoding").contains("gzip");
        boolean bl = requestTypeSupported = HttpMethod.POST.toString().equals(servletRequest.getMethod()) || HttpMethod.PUT.toString().equals(servletRequest.getMethod()) || HttpMethod.PATCH.toString().equals(servletRequest.getMethod());
        if (isGzipped && !requestTypeSupported) {
            throw new IllegalStateException(servletRequest.getMethod() + " is not supports gzipped body of parameters." + " Only POST requests are currently supported.");
        }
        if (isGzipped) {
            servletRequest = new GzippedInputStreamWrapper((HttpServletRequest)servletRequest);
        }
        chain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
    }

    public void destroy() {
    }

    final class GzippedInputStreamWrapper
    extends HttpServletRequestWrapper {
        private byte[] bytes;

        public GzippedInputStreamWrapper(HttpServletRequest request) throws IOException {
            super(request);
            try {
                GZIPInputStream in = new GZIPInputStream((InputStream)request.getInputStream());
                this.bytes = ByteStreams.toByteArray((InputStream)in);
            }
            catch (EOFException e) {
                this.bytes = new byte[0];
            }
        }

        public ServletInputStream getInputStream() throws IOException {
            final ByteArrayInputStream sourceStream = new ByteArrayInputStream(this.bytes);
            return new ServletInputStream(){

                public int read() throws IOException {
                    return sourceStream.read();
                }

                public void close() throws IOException {
                    super.close();
                    sourceStream.close();
                }
            };
        }

        public BufferedReader getReader() throws IOException {
            return new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.bytes)));
        }
    }
}

