/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.async;

import com.flipkart.poseidon.api.Application;
import com.flipkart.poseidon.api.Configuration;
import com.flipkart.poseidon.api.HeaderConfiguration;
import com.flipkart.poseidon.async.AsyncConsumerRequest;
import com.flipkart.poseidon.async.AsyncConsumerResult;
import com.flipkart.poseidon.async.AsyncResultState;
import com.flipkart.poseidon.core.PoseidonAsyncRequest;
import com.flipkart.poseidon.core.PoseidonRequest;
import com.flipkart.poseidon.core.PoseidonResponse;
import com.flipkart.poseidon.core.RequestContext;
import com.flipkart.poseidon.handlers.http.utils.StringUtils;
import com.flipkart.poseidon.helpers.MetricsHelper;
import com.flipkart.poseidon.metrics.Metrics;
import com.flipkart.poseidon.serviceclients.ServiceContext;
import com.google.common.collect.ImmutableMap;
import com.netflix.hystrix.HystrixRequestLog;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class PoseidonConsumer {
    private static final Logger logger = LoggerFactory.getLogger(PoseidonConsumer.class);
    private final Application application;
    private final Configuration configuration;

    public PoseidonConsumer(Application application, Configuration configuration) {
        this.application = application;
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AsyncConsumerResult consume(AsyncConsumerRequest consumerRequest) {
        Map<String, String> caseInsensitiveHeaders = Optional.ofNullable(consumerRequest.getHeaders()).orElse(Collections.emptyMap()).entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toLowerCase(), Map.Entry::getValue));
        PoseidonAsyncRequest request = new PoseidonAsyncRequest(consumerRequest.getUrl(), Collections.emptyMap(), caseInsensitiveHeaders, consumerRequest.getParameters());
        request.setAttribute("poseidon.method", (Object)consumerRequest.getHttpMethod());
        if (consumerRequest.getPayload() != null) {
            request.setAttribute("body_bytes", (Object)consumerRequest.getPayload());
        }
        HystrixRequestContext hystrixRequestContext = HystrixRequestContext.initializeContext();
        this.initAllContext((PoseidonRequest)request);
        PoseidonResponse response = null;
        try {
            response = new PoseidonResponse();
            this.application.handleRequest((PoseidonRequest)request, response);
            AsyncConsumerResult asyncConsumerResult = new AsyncConsumerResult(AsyncResultState.SUCCESS);
            return asyncConsumerResult;
        }
        catch (Throwable throwable) {
            logger.error("Unexpected exception while consuming async event", throwable);
            AsyncConsumerResult asyncConsumerResult = new AsyncConsumerResult(AsyncResultState.FAILURE);
            return asyncConsumerResult;
        }
        finally {
            this.ingestResponseBasedMetrics(response);
            this.logFailedHystrixCommands(consumerRequest);
            this.shutdownAllContext(hystrixRequestContext);
        }
    }

    private void initAllContext(PoseidonRequest request) {
        RequestContext.initialize();
        ServiceContext.initialize(this.configuration.getResponseHeadersToCollect());
        this.setContext(request);
    }

    private void setContext(PoseidonRequest request) {
        RequestContext.set((String)"poseidon.method", (Object)request.getAttribute("poseidon.method").toString());
        RequestContext.set((String)"sourceAddress", (Object)request.getUrl());
        if (this.configuration.getHeadersConfiguration() != null && this.configuration.getHeadersConfiguration().getGlobalHeaders() != null) {
            HashMap<String, String> headers = new HashMap<String, String>();
            for (HeaderConfiguration headerConfiguration : this.configuration.getHeadersConfiguration().getGlobalHeaders()) {
                String value = request.getHeader(headerConfiguration.getName());
                if (value == null) {
                    value = headerConfiguration.getDefaultValue();
                }
                if (value == null) continue;
                headers.put(headerConfiguration.getName(), value);
            }
            ImmutableMap immutableHeaders = ImmutableMap.copyOf(headers);
            ServiceContext.set((String)"headers", (Object)immutableHeaders);
            ServiceContext.set((String)"commands", new ConcurrentLinkedQueue());
            ServiceContext.set((String)"collect-commands", (Object)this.configuration.collectServiceClientCommandNames());
            ServiceContext.set((String)"throw-original-exceptions", (Object)this.configuration.throwOriginalExceptionsForNonUpstreamFailures());
            RequestContext.set((String)"poseidon.headers", (Object)immutableHeaders);
            MDC.setContextMap((Map)immutableHeaders);
        }
    }

    private void shutdownAllContext(HystrixRequestContext hystrixRequestContext) {
        RequestContext.shutDown();
        ServiceContext.shutDown();
        hystrixRequestContext.shutdown();
        MDC.clear();
    }

    private void ingestResponseBasedMetrics(PoseidonResponse response) {
        if (!StringUtils.isNullOrEmpty((String)((String)RequestContext.get((String)"poseidon.endpoint.name")))) {
            String status = response.getStatusCode() / 100 + "XX";
            Metrics.getRegistry().counter(MetricsHelper.getStatusCodeMetricsName((String)RequestContext.get((String)"poseidon.endpoint.name"), (String)RequestContext.get((String)"poseidon.method"), status)).inc();
        }
    }

    private void logFailedHystrixCommands(AsyncConsumerRequest request) {
        String url = request.getUrl();
        Map globalHeaders = (Map)RequestContext.get((String)"poseidon.headers");
        HystrixRequestLog.getCurrentRequest().getAllExecutedCommands().stream().filter(command -> command.isResponseTimedOut() || command.isFailedExecution() || command.isResponseShortCircuited() || command.isResponseRejected()).forEach(command -> logger.error("URL: {}. Global headers: {}. Command: {}. Events: {}. Exception: {}", new Object[]{url, globalHeaders, command.getCommandKey().name(), command.getExecutionEvents(), command.getFailedExecutionException() == null ? "" : command.getFailedExecutionException().getMessage()}));
    }
}

