/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.JvmAttributeGaugeSet;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.jetty9.InstrumentedHandler;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.codahale.metrics.servlets.AdminServlet;
import com.codahale.metrics.servlets.HealthCheckServlet;
import com.codahale.metrics.servlets.MetricsServlet;
import com.fasterxml.jackson.databind.JavaType;
import com.flipkart.phantom.runtime.impl.jetty.filter.ServletTraceFilter;
import com.flipkart.poseidon.api.Application;
import com.flipkart.poseidon.api.Configuration;
import com.flipkart.poseidon.api.JettyConfiguration;
import com.flipkart.poseidon.api.JettyFilterConfiguration;
import com.flipkart.poseidon.core.PoseidonServlet;
import com.flipkart.poseidon.core.RewriteRule;
import com.flipkart.poseidon.filters.HystrixContextFilter;
import com.flipkart.poseidon.filters.RequestGzipFilter;
import com.flipkart.poseidon.healthchecks.Rotation;
import com.flipkart.poseidon.helpers.ObjectMapperHelper;
import com.flipkart.poseidon.log4j.Log4JAccessLog;
import com.flipkart.poseidon.metrics.Metrics;
import com.flipkart.poseidon.rotation.BackInRotationServlet;
import com.flipkart.poseidon.rotation.OutOfRotationServlet;
import com.flipkart.poseidon.rotation.RotationCheckServlet;
import com.flipkart.poseidon.tracing.ServletTraceFilterBuilder;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.RewriteRegexRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.SessionCacheFactory;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.trpr.platform.runtime.impl.bootstrap.spring.Bootstrap;

@Service
public class Poseidon
implements ApplicationContextAware {
    public static final Logger STARTUP_LOGGER = LoggerFactory.getLogger((String)"PoseidonStartupLogger");
    private final Configuration configuration;
    private final Application application;
    private final RotationCheckServlet rotationCheckServlet;
    private final BackInRotationServlet backInRotationServlet;
    private final OutOfRotationServlet outOfRotationServlet;
    private final ExecutorService dataSourceES;
    private final ExecutorService filterES;
    private ApplicationContext context;
    private Server server;
    private SessionHandler sessionHandler;

    @Autowired
    public Poseidon(Configuration configuration, Application application, RotationCheckServlet rotationCheckServlet, BackInRotationServlet backInRotationServlet, OutOfRotationServlet outOfRotationServlet) {
        this.configuration = configuration;
        this.application = application;
        this.rotationCheckServlet = rotationCheckServlet;
        this.backInRotationServlet = backInRotationServlet;
        this.outOfRotationServlet = outOfRotationServlet;
        this.dataSourceES = Executors.newCachedThreadPool();
        this.filterES = Executors.newCachedThreadPool();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            throw new RuntimeException("No Bootstrap File Specified");
        }
        new Bootstrap().init(args[0]);
    }

    public void stop() {
        STARTUP_LOGGER.info("*** Poseidon - stopping application... ***");
        this.application.stop();
        STARTUP_LOGGER.info("*** Poseidon - stopping executor services... ***");
        this.dataSourceES.shutdown();
        this.filterES.shutdown();
        if (this.server != null) {
            STARTUP_LOGGER.info("*** Poseidon - stopping server... ***");
            try {
                this.server.stop();
            }
            catch (Exception e) {
                STARTUP_LOGGER.error("Exception stopping server", (Throwable)e);
            }
        }
        STARTUP_LOGGER.info("*** Poseidon stopped ***");
    }

    public void start() {
        try {
            JettyConfiguration jettyConfiguration = this.configuration.getJettyConfiguration();
            if (jettyConfiguration != null) {
                ArrayBlockingQueue queue = new ArrayBlockingQueue(jettyConfiguration.getTaskQueueSize());
                QueuedThreadPool threadPool = new QueuedThreadPool(jettyConfiguration.getMaxThreads(), jettyConfiguration.getMinThreads(), jettyConfiguration.getThreadIdleTimeout(), queue);
                this.server = new Server((ThreadPool)threadPool);
                ServerConnector connector = new ServerConnector(this.server, jettyConfiguration.getAcceptors(), jettyConfiguration.getSelectors(), new ConnectionFactory[]{(ConnectionFactory)Optional.ofNullable(jettyConfiguration.getHttpConnectionFactory()).orElseGet(HttpConnectionFactory::new)});
                connector.setPort(this.configuration.getPort());
                connector.setAcceptQueueSize(jettyConfiguration.getAcceptQueueSize());
                this.server.setConnectors(new Connector[]{connector});
                this.initializeSessionManagement(jettyConfiguration);
            } else {
                this.server = new Server(this.configuration.getPort());
            }
            if (!this.configuration.sendServerVersion()) {
                this.disableSendingServerVersion();
            }
            this.server.setHandler((Handler)this.getHandlers());
            this.application.init(this.dataSourceES, this.filterES, this.context);
            Poseidon.initializeMetricReporters();
            this.server.start();
            STARTUP_LOGGER.info("*** Poseidon started ***");
        }
        catch (Exception e) {
            STARTUP_LOGGER.error("Unable to start Poseidon.", (Throwable)e);
            throw new RuntimeException("Unable to start Poseidon", e);
        }
    }

    private HandlerCollection getHandlers() {
        ContextHandlerCollection contextHandlerCollection = new ContextHandlerCollection();
        contextHandlerCollection.setHandlers(new Handler[]{this.getRequestLogHandler(this.getGzipHandler(this.getParentHandler())), this.getMetricsHandler()});
        return contextHandlerCollection;
    }

    private Handler getGzipHandler(Handler handler) {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.addIncludedMethods(new String[]{"GET", "POST", "PUT", "DELETE", "PATCH"});
        gzipHandler.addIncludedPaths(new String[]{"/*"});
        gzipHandler.setHandler(handler);
        return gzipHandler;
    }

    private Handler getRequestLogHandler(Handler handler) {
        Log4JAccessLog requestLog = new Log4JAccessLog(this.configuration.getAccessLogConfigFilePath(), () -> this.configuration.isAccessLogEnabled());
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        requestLogHandler.setHandler(handler);
        return requestLogHandler;
    }

    private Handler getParentHandler() {
        Handler poseidonHandler = this.getPoseidonHandler();
        return this.getRewriteHandler(poseidonHandler).orElse(poseidonHandler);
    }

    private Optional<Handler> getRewriteHandler(Handler handler) {
        try {
            String rewriteFilePath = this.configuration.getRewriteFilePath();
            if (rewriteFilePath != null && !(rewriteFilePath = rewriteFilePath.trim()).isEmpty()) {
                RewriteHandler rewriteHandler = new RewriteHandler();
                rewriteHandler.setRewritePathInfo(false);
                rewriteHandler.setRewriteRequestURI(true);
                rewriteHandler.setOriginalPathAttribute("__path");
                rewriteHandler.setHandler(handler);
                JavaType listRuleType = ObjectMapperHelper.getMapper().getTypeFactory().constructParametricType(List.class, new Class[]{RewriteRule.class});
                List rules = (List)ObjectMapperHelper.getMapper().readValue((InputStream)new FileInputStream(rewriteFilePath), listRuleType);
                boolean isAnyRuleActive = false;
                for (RewriteRule rule : rules) {
                    if (!rule.isActive()) continue;
                    RewriteRegexRule regexRule = new RewriteRegexRule();
                    regexRule.setRegex(rule.getFrom());
                    regexRule.setReplacement(rule.getTo());
                    rewriteHandler.addRule((Rule)regexRule);
                    isAnyRuleActive = true;
                }
                return isAnyRuleActive ? Optional.of(rewriteHandler) : Optional.empty();
            }
        }
        catch (IOException e) {
            STARTUP_LOGGER.error("Unable to read Rewrite Rules", (Throwable)e);
        }
        return Optional.empty();
    }

    private Handler getPoseidonHandler() {
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        servletContextHandler.setContextPath("/");
        servletContextHandler.addServlet(new ServletHolder((Servlet)this.getPoseidonServlet()), "/*");
        servletContextHandler.addServlet(new ServletHolder((Servlet)this.rotationCheckServlet), "/_poseidon/rotation");
        servletContextHandler.addServlet(new ServletHolder((Servlet)this.backInRotationServlet), "/_poseidon/bir");
        servletContextHandler.addServlet(new ServletHolder((Servlet)this.outOfRotationServlet), "/_poseidon/oor");
        if (this.sessionHandler != null) {
            servletContextHandler.setSessionHandler(this.sessionHandler);
        }
        this.configuration.registerServlets().forEach(servlet -> servletContextHandler.addServlet((ServletHolder)servlet.getRight(), (String)servlet.getLeft()));
        this.addFilters(servletContextHandler);
        InstrumentedHandler instrumentedHandler = new InstrumentedHandler(Metrics.getRegistry());
        instrumentedHandler.setHandler((Handler)servletContextHandler);
        return instrumentedHandler;
    }

    private ServletContextHandler getMetricsHandler() {
        MetricRegistry registry = Metrics.getRegistry();
        HealthCheckRegistry healthCheckRegistry = Metrics.getHealthCheckRegistry();
        healthCheckRegistry.register("rotation", (HealthCheck)new Rotation(this.configuration.getRotationStatusFilePath()));
        registry.registerAll((MetricSet)new GarbageCollectorMetricSet());
        registry.registerAll((MetricSet)new MemoryUsageGaugeSet());
        registry.registerAll((MetricSet)new ThreadStatesGaugeSet());
        registry.registerAll((MetricSet)new JvmAttributeGaugeSet());
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        servletContextHandler.setContextPath("/__metrics");
        servletContextHandler.setAttribute(MetricsServlet.class.getCanonicalName() + ".registry", (Object)registry);
        servletContextHandler.setAttribute(HealthCheckServlet.class.getCanonicalName() + ".registry", (Object)healthCheckRegistry);
        servletContextHandler.addServlet(new ServletHolder((Servlet)new AdminServlet()), "/*");
        return servletContextHandler;
    }

    private static void initializeMetricReporters() {
        JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)Metrics.getRegistry()).build();
        jmxReporter.start();
    }

    private void addFilters(ServletContextHandler servletContextHandler) {
        servletContextHandler.addFilter(new FilterHolder((Filter)new HystrixContextFilter(this.configuration)), "/*", EnumSet.of(DispatcherType.REQUEST));
        ServletTraceFilter servletTraceFilter = ServletTraceFilterBuilder.build(this.configuration);
        if (servletTraceFilter != null) {
            servletContextHandler.addFilter(new FilterHolder((Filter)servletTraceFilter), "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        servletContextHandler.addFilter(new FilterHolder((Filter)new RequestGzipFilter()), "/*", EnumSet.of(DispatcherType.REQUEST));
        List jettyFilterConfigurations = Optional.ofNullable(this.configuration.getJettyConfiguration()).map(JettyConfiguration::getJettyFilterConfigurations).orElse(new ArrayList());
        for (JettyFilterConfiguration filterConfig : jettyFilterConfigurations) {
            FilterHolder filterHolder = new FilterHolder(filterConfig.getFilter());
            filterHolder.setInitParameters(filterConfig.getInitParameters());
            for (String mapping : filterConfig.getMappings()) {
                servletContextHandler.addFilter(filterHolder, mapping, filterConfig.getDispatcherTypes());
            }
        }
    }

    private PoseidonServlet getPoseidonServlet() {
        return new PoseidonServlet(this.application, this.configuration);
    }

    private void disableSendingServerVersion() {
        for (Connector connector : this.server.getConnectors()) {
            for (ConnectionFactory connectionFactory : connector.getConnectionFactories()) {
                if (!(connectionFactory instanceof HttpConnectionFactory)) continue;
                ((HttpConnectionFactory)connectionFactory).getHttpConfiguration().setSendServerVersion(false);
            }
        }
    }

    private void initializeSessionManagement(JettyConfiguration jettyConfiguration) {
        SessionIdManager sessionIdManager = jettyConfiguration.getSessionIdManager(this.server);
        if (sessionIdManager != null) {
            this.server.setSessionIdManager(sessionIdManager);
            this.sessionHandler = new SessionHandler();
            this.sessionHandler.setSessionIdManager(sessionIdManager);
            SessionCacheFactory sessionCacheFactory = jettyConfiguration.getSessionCacheFactory();
            if (sessionCacheFactory != null) {
                this.server.addBean((Object)sessionCacheFactory);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

