/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.helpers;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostHelper {
    private static final Logger logger = LoggerFactory.getLogger(HostHelper.class);
    private static String hostname;
    private static String shortName;
    private static String hostnameGroup;
    private static String shortNameGroup;
    private static String hostIP;

    public static String getHostName(String defaultValue) {
        return hostname == null ? defaultValue : hostname;
    }

    public static String getHostGroup(String defaultValue) {
        return hostnameGroup == null ? defaultValue : hostnameGroup;
    }

    public static String getShortHostName(String defaultValue) {
        return shortName == null ? defaultValue : shortName;
    }

    public static String getShortHostGroup(String defaultValue) {
        return shortNameGroup == null ? defaultValue : shortNameGroup;
    }

    public static String getHostIP(String defaultValue) {
        return hostIP == null ? defaultValue : hostIP;
    }

    static {
        try {
            hostIP = InetAddress.getLocalHost().getHostAddress();
            hostname = InetAddress.getLocalHost().getCanonicalHostName();
            shortName = hostname.split("\\.")[0];
            hostnameGroup = hostname.replaceAll("-?[0-9]+\\.", ".");
            shortNameGroup = hostnameGroup.split("\\.")[0];
        }
        catch (UnknownHostException e) {
            logger.warn("Unable to get hostname", (Throwable)e);
        }
    }
}

