/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.filters;

import com.flipkart.poseidon.helpers.ObjectMapperHelper;
import com.flipkart.poseidon.model.trace.DebugAPI;
import com.flipkart.poseidon.model.trace.ServiceCallDebug;
import com.flipkart.poseidon.serviceclients.ServiceClientException;
import com.flipkart.poseidon.serviceclients.ServiceContext;
import com.flipkart.poseidon.serviceclients.ServiceDebug;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class DebugFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest;
        Object response = servletResponse;
        if (servletRequest instanceof HttpServletRequest) {
            httpServletRequest = (HttpServletRequest)servletRequest;
            if (httpServletRequest.getParameter("whatIsWrongWithThis") != null) {
                ServiceContext.enableDebug();
                response = new HttpServletResponseCopier((HttpServletResponse)servletResponse);
            }
            filterChain.doFilter((ServletRequest)httpServletRequest, response);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        if (ServiceContext.isDebug()) {
            httpServletRequest = (HttpServletRequest)servletRequest;
            String includeOnlyServices = httpServletRequest.getParameter("includeOnly");
            boolean disableServiceResponses = httpServletRequest.getParameterMap().containsKey("disableServiceResponses");
            Map<String, List<ServiceDebug>> callDebug = this.filterWantedServices(includeOnlyServices, ServiceContext.getDebugResponses());
            this.filterDisabledServices(httpServletRequest, callDebug);
            HashMap<String, List<ServiceCallDebug>> serviceCallDebugMap = new HashMap<String, List<ServiceCallDebug>>();
            for (Map.Entry<String, List<ServiceDebug>> entry : callDebug.entrySet()) {
                List<ServiceDebug> serviceDebugs = entry.getValue();
                if (serviceDebugs == null) continue;
                ArrayList<ServiceCallDebug> serviceCallDebugs = new ArrayList<ServiceCallDebug>();
                for (ServiceDebug serviceDebug : serviceDebugs) {
                    ServiceCallDebug serviceCallDebug = this.convertToServiceCallDebug(serviceDebug, disableServiceResponses);
                    serviceCallDebugs.add(serviceCallDebug);
                }
                serviceCallDebugMap.put(entry.getKey(), serviceCallDebugs);
            }
            this.generateDebugResponse((HttpServletResponseCopier)((Object)response), serviceCallDebugMap);
        }
    }

    protected List<String> disabledDebugServices(HttpServletRequest request) {
        return new ArrayList<String>();
    }

    private void filterDisabledServices(HttpServletRequest request, Map<String, List<ServiceDebug>> callDebug) {
        List<String> disabledServices = this.disabledDebugServices(request);
        if (disabledServices.isEmpty()) {
            return;
        }
        disabledServices.forEach(callDebug::remove);
    }

    private void generateDebugResponse(HttpServletResponseCopier responseCopier, Map<String, List<ServiceCallDebug>> serviceCallDebugMap) throws IOException {
        DebugAPI debugAPI = new DebugAPI();
        debugAPI.setServiceCallInfo(serviceCallDebugMap);
        responseCopier.flushBuffer();
        try {
            debugAPI.setApiResponse(ObjectMapperHelper.getMapper().readValue(responseCopier.getCopyAsString(), Map.class));
        }
        catch (Exception e) {
            debugAPI.setApiResponse((Object)responseCopier.getCopyAsString());
        }
        debugAPI.setApiStatus(responseCopier.getStatus());
        responseCopier.setStatus(200);
        responseCopier.getWriter().write(ObjectMapperHelper.getMapper().writeValueAsString((Object)debugAPI));
        responseCopier.flushBuffer();
    }

    private ServiceCallDebug convertToServiceCallDebug(ServiceDebug serviceDebug, boolean disableServiceResponses) {
        Object serviceResponse;
        ServiceCallDebug serviceCallDebug = new ServiceCallDebug();
        serviceCallDebug.setHeadersMap(serviceDebug.getProperties().getHeadersMap());
        serviceCallDebug.setHttpMethod(serviceDebug.getProperties().getHttpMethod());
        serviceCallDebug.setRequestObject(serviceDebug.getProperties().getRequestObject());
        serviceCallDebug.setUri(serviceDebug.getProperties().getUri());
        if (disableServiceResponses) {
            return serviceCallDebug;
        }
        try {
            serviceResponse = serviceDebug.getResponsePromise().get();
            serviceCallDebug.setResponseHeaders(serviceDebug.getResponsePromise().getHeaders());
        }
        catch (ServiceClientException e) {
            serviceResponse = e.getErrorResponse();
            serviceCallDebug.setSuccess(false);
            serviceCallDebug.setErrorIdentifier(((Object)((Object)e)).getClass().getName());
            try {
                serviceCallDebug.setResponseHeaders(serviceDebug.getResponsePromise().getHeaders());
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            serviceResponse = e;
            serviceCallDebug.setSuccess(false);
            serviceCallDebug.setErrorIdentifier(e.getClass().getName());
            try {
                serviceCallDebug.setResponseHeaders(serviceDebug.getResponsePromise().getHeaders());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        serviceCallDebug.setServiceResponse(serviceResponse);
        return serviceCallDebug;
    }

    private Map<String, List<ServiceDebug>> filterWantedServices(String includeOnlyServices, Map<String, List<ServiceDebug>> callDebug) {
        if (includeOnlyServices != null) {
            List<String> includedServices = Arrays.asList(includeOnlyServices.split(","));
            return callDebug.entrySet().stream().filter(e -> includedServices.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return callDebug;
    }

    public void destroy() {
    }

    class ServletOutputStreamCopier
    extends ServletOutputStream {
        private OutputStream outputStream;
        private ByteArrayOutputStream copy;

        public ServletOutputStreamCopier(OutputStream outputStream) {
            this.outputStream = outputStream;
            this.copy = new ByteArrayOutputStream(1024);
        }

        public void write(int b) throws IOException {
            this.outputStream.write(b);
            this.copy.write(b);
        }

        public byte[] getCopy() {
            return this.copy.toByteArray();
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }

    class HttpServletResponseCopier
    extends HttpServletResponseWrapper {
        private ServletOutputStream outputStream;
        private PrintWriter writer;
        private ServletOutputStreamCopier copier;

        public HttpServletResponseCopier(HttpServletResponse response) throws IOException {
            super(response);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.writer != null) {
                throw new IllegalStateException("getWriter() has already been called on this response.");
            }
            if (this.outputStream == null) {
                this.outputStream = this.getResponse().getOutputStream();
                this.copier = new ServletOutputStreamCopier((OutputStream)this.outputStream);
            }
            return this.copier;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.outputStream != null) {
                throw new IllegalStateException("getOutputStream() has already been called on this response.");
            }
            this.copier = this.writer == null ? new ServletOutputStreamCopier(new ByteArrayOutputStream()) : new ServletOutputStreamCopier((OutputStream)this.getResponse().getOutputStream());
            this.writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)((Object)this.copier), this.getResponse().getCharacterEncoding()), false);
            return this.writer;
        }

        public void flushBuffer() throws IOException {
            if (this.writer != null) {
                this.writer.flush();
            } else if (this.outputStream != null) {
                this.copier.flush();
            }
        }

        public byte[] getCopy() {
            if (this.copier != null) {
                return this.copier.getCopy();
            }
            return new byte[0];
        }

        public String getCopyAsString() throws IOException {
            return new String(this.getCopy(), this.getCharacterEncoding());
        }
    }
}

